package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum InvoiceKind {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普票发票"),
    SE("se", "增值税电子专用发票"),
    JU("ju", "增值税普通发票（卷票）"),
    CB("cb", "电子普通发票（区块链）"),
    V("v", "机动车统一销售发票"),
    T("t", "通用机打发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    VS("vs", "二手车销售统一发票"),
    CP("cp", "海关缴款书"),
    CD("cd", "通用电子发票"),
    QC("qc", "全电增值税电子普通发票 "),
    QS("qs", "全电增值税电子专用发票"),
    CZ("cz", "全电增值税纸质普通发票"),
    SZ("sz", "全电增值税纸质专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind fromCode(String code) {
        return Stream.of(InvoiceKind.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
