package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票样式
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum InvoiceStyleType {

    _1("1", "1");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStyleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStyleType fromCode(String code) {
        return Stream.of(InvoiceStyleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
