package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 行业特殊票种类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum ItemTypeCode {

    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ItemTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemTypeCode fromCode(String code) {
        return Stream.of(ItemTypeCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
