package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum MatchStatus {

    _0("0", "匹配失败"),
    _4("4", "已驳回"),
    _1("1", "不满足条件"),
    _2("2", "匹配失败"),
    _3("3", "已匹配");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code) {
        return Stream.of(MatchStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
