package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 流程操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum OperateType {

    _01("01", "提交"),
    _02("02", "审批"),
    _03("03", "复核"),
    _04("04", "跟进"),
    _05("05", "确认红字"),
    _06("06", "关闭"),
    _07("07", "完结"),
    _08("08", "终止"),
    _09("09", "上传税局"),
    _10("10", "系统下发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperateType fromCode(String code) {
        return Stream.of(OperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
