package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 申请单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum RedFlushWorkflowType {

    _01("01", "红字信息表申请"),
    _02("02", "红字信息表撤销申请"),
    _03("03", "红字确认单申请"),
    _04("04", "红字确认单撤销申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedFlushWorkflowType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedFlushWorkflowType fromCode(String code) {
        return Stream.of(RedFlushWorkflowType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
