package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票特殊类型标识
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum SpecialType {

    _0("0", "默认"),
    _1("1", "通行费"),
    _2("2", "成品油");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialType fromCode(String code) {
        return Stream.of(SpecialType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
