package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 接口同步状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum SyncStatus {

    _0("0", "待同步"),
    _1("1", "同步成功"),
    _2("2", "同步失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SyncStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SyncStatus fromCode(String code) {
        return Stream.of(SyncStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
