package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 纳税人类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum TaxpayerType {

    _0("0", "小规模纳税人"),
    _1("1", "一般纳税人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxpayerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxpayerType fromCode(String code) {
        return Stream.of(TaxpayerType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
