package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 性别
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum Test {

    MAN("man", "男"),
    WOMAN("woman", "女");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Test(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Test fromCode(String code) {
        return Stream.of(Test.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
