package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 凭证生成状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum VoucherStatus {

    _0("0", "待生成"),
    _1("1", "生成成功"),
    _2("2", "生成失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VoucherStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherStatus fromCode(String code) {
        return Stream.of(VoucherStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
