package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 流程状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum WorkflowStatus {

    _01("01", "待提交"),
    _02("02", "待审批"),
    _03("03", "待复核"),
    _04("04", "审批通过"),
    _05("05", "确认中"),
    _06("06", "待跟进"),
    _07("07", "已完结");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WorkflowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WorkflowStatus fromCode(String code) {
        return Stream.of(WorkflowStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
