package com.xforceplus.ultraman.app.jcwatsons.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * examine_manage
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExamineManage implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 申请单类型
   */
  private String workflowType;
  /**
   * 申请单名称
   */
  private String applyName;
  /**
   * 申请单编号
   */
  private String applyNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 购方名称
   */
  private String buyerName;
  /**
   * 购方税号
   */
  private String buyerTaxNo;
  /**
   * 申请人员
   */
  private String applyUser;
  /**
   * 申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;
  /**
   * 申请说明
   */
  private String applyReason;
  /**
   * 流程状态
   */
  private String workflowStatus;
  /**
   * 完结类型
   */
  private String endType;
  /**
   * 完结备注
   */
  private String endRemark;
  /**
   * 上传失败原因
   */
  private String uploadFailReason;
  /**
   * 审核人
   */
  private String auditingUser;
  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditingTime;
  /**
   * 复核人
   */
  private String examineUser;
  /**
   * 复核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime examineTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 历史红字确认单编号
   */
  private String historyRedLetterNumber;
  /**
   * 申请批次号
   */
  private String applyBatchNum;
  /**
   * 申请人ID
   */
  private Long applyUserId;
  /**
   * 审核人ID
   */
  private Long auditingUserId;
  /**
   * 复核人ID
   */
  private Long examineUserId;
  /**
   * 审核人邮箱
   */
  private String auditingUserEmail;
  /**
   * 复核人邮箱
   */
  private String examineUserEmail;
  /**
   * 申请人组别
   */
  private String applyGroup;
  /**
   * 复核人组别
   */
  private String examineGroup;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("workflowType", workflowType);
      map.put("applyName", applyName);
      map.put("applyNo", applyNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("applyUser", applyUser);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("applyReason", applyReason);
      map.put("workflowStatus", workflowStatus);
      map.put("endType", endType);
      map.put("endRemark", endRemark);
      map.put("uploadFailReason", uploadFailReason);
      map.put("auditingUser", auditingUser);
      map.put("auditingTime", BocpGenUtils.toTimestamp(auditingTime));
      map.put("examineUser", examineUser);
      map.put("examineTime", BocpGenUtils.toTimestamp(examineTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("historyRedLetterNumber", historyRedLetterNumber);
      map.put("applyBatchNum", applyBatchNum);
      map.put("applyUserId", applyUserId);
      map.put("auditingUserId", auditingUserId);
      map.put("examineUserId", examineUserId);
      map.put("auditingUserEmail", auditingUserEmail);
      map.put("examineUserEmail", examineUserEmail);
      map.put("applyGroup", applyGroup);
      map.put("examineGroup", examineGroup);

      return map;
  }

  public static ExamineManage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExamineManage entity = new ExamineManage();

    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkflowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("workflowStatus")) {
      Object obj = map.get("workflowStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkflowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endType")) {
      Object obj = map.get("endType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endRemark")) {
      Object obj = map.get("endRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadFailReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditingTime(null);
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExamineTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("historyRedLetterNumber")) {
      Object obj = map.get("historyRedLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHistoryRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyBatchNum")) {
      Object obj = map.get("applyBatchNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyBatchNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setApplyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditingUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAuditingUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExamineUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExamineUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineGroup((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWorkflowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyName")) {
      Object obj = map.get("applyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("workflowStatus")) {
      Object obj = map.get("workflowStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWorkflowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endType")) {
      Object obj = map.get("endType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEndType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endRemark")) {
      Object obj = map.get("endRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEndRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUploadFailReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditingUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuditingTime(null);
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExamineUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExamineTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("historyRedLetterNumber")) {
      Object obj = map.get("historyRedLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHistoryRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyBatchNum")) {
      Object obj = map.get("applyBatchNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyBatchNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApplyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setApplyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditingUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuditingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAuditingUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExamineUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExamineUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setExamineUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditingUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExamineUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExamineGroup((String)obj);
        }
      } else{
      }
    }
  }
}
