package com.xforceplus.ultraman.app.jcwatsons.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * red_information_manage
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RedInformationManage implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 账户类型
   */
  private String accountType;
  /**
   * 流水号
   */
  private String applySerialNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 购方名称
   */
  private String buyerName;
  /**
   * 购方税号
   */
  private String buyerTaxNo;
  /**
   * 含税金额
   */
  private String amountWithTax;
  /**
   * 不含税金额
   */
  private String amountWithoutTax;
  /**
   * 税额
   */
  private String taxAmount;
  /**
   * 原发票号码
   */
  private String originalInvoiceNo;
  /**
   * 原发票代码
   */
  private String originalInvoiceCode;
  /**
   * 原发票类型
   */
  private String originalInvoiceType;
  /**
   * 红字信息表申请状态
   */
  private String applyingStatus;
  /**
   * 业务申请原因
   */
  private String businessRemark;
  /**
   * 红字信息表编号
   */
  private String applyTaxNo;
  /**
   * 红字信息表PDF
   */
  private String redInfoUrl;
  /**
   * 红字发票代码
   */
  private String redInvoiceCode;
  /**
   * 红字发票号码
   */
  private String redInvoiceNo;
  /**
   * 红字发票开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redPaperDrewDate;
  /**
   * 红字发票不含税金额
   */
  private String redAmountWithoutTax;
  /**
   * 红字发票税额
   */
  private String redTaxAmount;
  /**
   * 红字发票含税金额
   */
  private String redAmountWithTax;
  /**
   * 红字发票回收日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redRecoveryDate;
  /**
   * 红字发票差异原因
   */
  private String redDifferencesReason;
  /**
   * 红字信息表审核状态
   */
  private String applyStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 终端唯一码
   */
  private String terminalUn;
  /**
   * 设备唯一码
   */
  private String deviceUn;
  /**
   * 红字申请类型
   */
  private String applyReason;
  /**
   * 系统来源
   */
  private String systenOrign;
  /**
   * 红冲申请原因
   */
  private String redLetterReason;
  /**
   * 原蓝票开票日期
   */
  private String originalDateIssued;

  /**
   * 对一关联关系 关联对象 examineManage
   */
  private Long examineAndRedInformationRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("accountType", accountType);
      map.put("applySerialNo", applySerialNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("originalInvoiceType", originalInvoiceType);
      map.put("applyingStatus", applyingStatus);
      map.put("businessRemark", businessRemark);
      map.put("applyTaxNo", applyTaxNo);
      map.put("redInfoUrl", redInfoUrl);
      map.put("redInvoiceCode", redInvoiceCode);
      map.put("redInvoiceNo", redInvoiceNo);
      map.put("redPaperDrewDate", BocpGenUtils.toTimestamp(redPaperDrewDate));
      map.put("redAmountWithoutTax", redAmountWithoutTax);
      map.put("redTaxAmount", redTaxAmount);
      map.put("redAmountWithTax", redAmountWithTax);
      map.put("redRecoveryDate", BocpGenUtils.toTimestamp(redRecoveryDate));
      map.put("redDifferencesReason", redDifferencesReason);
      map.put("applyStatus", applyStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("terminalUn", terminalUn);
      map.put("deviceUn", deviceUn);
      map.put("applyReason", applyReason);
      map.put("systenOrign", systenOrign);
      map.put("redLetterReason", redLetterReason);
      map.put("originalDateIssued", originalDateIssued);

      map.put("examineAndRedInformationRelation.id", examineAndRedInformationRelationId);
      return map;
  }

  public static RedInformationManage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RedInformationManage entity = new RedInformationManage();

    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applySerialNo")) {
      Object obj = map.get("applySerialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplySerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceType")) {
      Object obj = map.get("originalInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyingStatus")) {
      Object obj = map.get("applyingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessRemark")) {
      Object obj = map.get("businessRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTaxNo")) {
      Object obj = map.get("applyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInfoUrl")) {
      Object obj = map.get("redInfoUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInfoUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceCode")) {
      Object obj = map.get("redInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceNo")) {
      Object obj = map.get("redInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRedPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedPaperDrewDate(null);
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redRecoveryDate")) {
      Object obj = map.get("redRecoveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedRecoveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRedRecoveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedRecoveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedRecoveryDate(null);
      }
    }
    if(map.containsKey("redDifferencesReason")) {
      Object obj = map.get("redDifferencesReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedDifferencesReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyStatus")) {
      Object obj = map.get("applyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalUn")) {
      Object obj = map.get("terminalUn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTerminalUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceUn")) {
      Object obj = map.get("deviceUn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systenOrign")) {
      Object obj = map.get("systenOrign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystenOrign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterReason")) {
      Object obj = map.get("redLetterReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalDateIssued")) {
      Object obj = map.get("originalDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalDateIssued((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("examineAndRedInformationRelation.id")) {
       Object obj = map.get("examineAndRedInformationRelation.id");
       if(obj instanceof Long) {
         entity.setExamineAndRedInformationRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setExamineAndRedInformationRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applySerialNo")) {
      Object obj = map.get("applySerialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplySerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceType")) {
      Object obj = map.get("originalInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyingStatus")) {
      Object obj = map.get("applyingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessRemark")) {
      Object obj = map.get("businessRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTaxNo")) {
      Object obj = map.get("applyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInfoUrl")) {
      Object obj = map.get("redInfoUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedInfoUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceCode")) {
      Object obj = map.get("redInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceNo")) {
      Object obj = map.get("redInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRedPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRedPaperDrewDate(null);
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redRecoveryDate")) {
      Object obj = map.get("redRecoveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRedRecoveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRedRecoveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRedRecoveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRedRecoveryDate(null);
      }
    }
    if(map.containsKey("redDifferencesReason")) {
      Object obj = map.get("redDifferencesReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedDifferencesReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyStatus")) {
      Object obj = map.get("applyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("terminalUn")) {
      Object obj = map.get("terminalUn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTerminalUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceUn")) {
      Object obj = map.get("deviceUn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeviceUn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systenOrign")) {
      Object obj = map.get("systenOrign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystenOrign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterReason")) {
      Object obj = map.get("redLetterReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedLetterReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalDateIssued")) {
      Object obj = map.get("originalDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalDateIssued((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("examineAndRedInformationRelation.id")) {
    Object obj = map.get("examineAndRedInformationRelation.id");
    if(obj instanceof Long) {
        this.setExamineAndRedInformationRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setExamineAndRedInformationRelationId(Long.parseLong((String)obj));
    }
  }
  }
}
