package com.xforceplus.ultraman.app.jcwatsons.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * special_additions
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SpecialAdditions implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 运输工具种类（货运运输）
   */
  private String toolType;
  /**
   * 运输工具牌号（货运运输）
   */
  private String toolBrand;
  /**
   * 运输货物名称（货运运输）
   */
  private String nameOfGoods;
  /**
   * 起运地（货运运输）
   */
  private String placeOfShipment;
  /**
   * 到达地（货运运输）
   */
  private String destination;
  /**
   * 发生详细地址（建筑服务）
   */
  private String placeOfOccurrence;
  /**
   * 建筑项目名称（建筑服务）
   */
  private String entryName;
  /**
   * 建筑服务发生地（建筑服务）
   */
  private String place;
  /**
   * 不动产详细地址（不动产销售）
   */
  private String realEstateCode;
  /**
   * 核定计税价格（不动产销售）
   */
  private String taxablePrice;
  /**
   * 实际成交含税金额（不动产销售）
   */
  private String transactionPrice;
  /**
   * 租赁期起（不动产租赁）
   */
  private String leaseTermStart;
  /**
   * 租赁期止（不动产租赁）
   */
  private String leaseTermEnd;
  /**
   * 跨地市标志（建筑服务/不动产销售/不动产租赁）
   */
  private Boolean crossCitySign;
  /**
   * 土地增值税项目编号（建筑服务/不动产销售）
   */
  private String landVatItemNo;
  /**
   * 房屋产权证书/不动产权证号码（不动产销售/不动产租赁）
   */
  private String realEstateNo;
  /**
   * 不动产详细地址（不动产销售/不动产租赁）
   */
  private String realEstateAddress;
  /**
   * 面积单位
   */
  private String areaUnit;
  /**
   * 不动产地址（省市区）（不动产销售/不动产租赁）
   */
  private String realEstatePlace;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("toolType", toolType);
      map.put("toolBrand", toolBrand);
      map.put("nameOfGoods", nameOfGoods);
      map.put("placeOfShipment", placeOfShipment);
      map.put("destination", destination);
      map.put("placeOfOccurrence", placeOfOccurrence);
      map.put("entryName", entryName);
      map.put("place", place);
      map.put("realEstateCode", realEstateCode);
      map.put("taxablePrice", taxablePrice);
      map.put("transactionPrice", transactionPrice);
      map.put("leaseTermStart", leaseTermStart);
      map.put("leaseTermEnd", leaseTermEnd);
      map.put("crossCitySign", crossCitySign);
      map.put("landVatItemNo", landVatItemNo);
      map.put("realEstateNo", realEstateNo);
      map.put("realEstateAddress", realEstateAddress);
      map.put("areaUnit", areaUnit);
      map.put("realEstatePlace", realEstatePlace);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static SpecialAdditions fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SpecialAdditions entity = new SpecialAdditions();

    if(map.containsKey("toolType")) {
      Object obj = map.get("toolType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setToolType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toolBrand")) {
      Object obj = map.get("toolBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setToolBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameOfGoods")) {
      Object obj = map.get("nameOfGoods");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameOfGoods((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfShipment")) {
      Object obj = map.get("placeOfShipment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfShipment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDestination((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfOccurrence")) {
      Object obj = map.get("placeOfOccurrence");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfOccurrence((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryName")) {
      Object obj = map.get("entryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("place")) {
      Object obj = map.get("place");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateCode")) {
      Object obj = map.get("realEstateCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstateCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxablePrice")) {
      Object obj = map.get("taxablePrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxablePrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transactionPrice")) {
      Object obj = map.get("transactionPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransactionPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermStart")) {
      Object obj = map.get("leaseTermStart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaseTermStart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermEnd")) {
      Object obj = map.get("leaseTermEnd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaseTermEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("crossCitySign")) {
      Object obj = map.get("crossCitySign");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCrossCitySign((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCrossCitySign(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("landVatItemNo")) {
      Object obj = map.get("landVatItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLandVatItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateNo")) {
      Object obj = map.get("realEstateNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateAddress")) {
      Object obj = map.get("realEstateAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstateAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("areaUnit")) {
      Object obj = map.get("areaUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstatePlace")) {
      Object obj = map.get("realEstatePlace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstatePlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("toolType")) {
      Object obj = map.get("toolType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setToolType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toolBrand")) {
      Object obj = map.get("toolBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setToolBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameOfGoods")) {
      Object obj = map.get("nameOfGoods");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNameOfGoods((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfShipment")) {
      Object obj = map.get("placeOfShipment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlaceOfShipment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDestination((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfOccurrence")) {
      Object obj = map.get("placeOfOccurrence");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlaceOfOccurrence((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryName")) {
      Object obj = map.get("entryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEntryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("place")) {
      Object obj = map.get("place");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateCode")) {
      Object obj = map.get("realEstateCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRealEstateCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxablePrice")) {
      Object obj = map.get("taxablePrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxablePrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transactionPrice")) {
      Object obj = map.get("transactionPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTransactionPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermStart")) {
      Object obj = map.get("leaseTermStart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLeaseTermStart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermEnd")) {
      Object obj = map.get("leaseTermEnd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLeaseTermEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("crossCitySign")) {
      Object obj = map.get("crossCitySign");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setCrossCitySign((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCrossCitySign(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("landVatItemNo")) {
      Object obj = map.get("landVatItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLandVatItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateNo")) {
      Object obj = map.get("realEstateNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRealEstateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateAddress")) {
      Object obj = map.get("realEstateAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRealEstateAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("areaUnit")) {
      Object obj = map.get("areaUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAreaUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstatePlace")) {
      Object obj = map.get("realEstatePlace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRealEstatePlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
