package com.xforceplus.ultraman.app.jcwatsons.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-05-11
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1638437137301958657L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1638437138052739073L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1638437138744799234L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1638437139633991681L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface TaxNumberList {
        static Long id() {
            return 1640706611421458433L;
        }
        static String code() {
            return "taxNumberList";
        }
        TypedField<String> MARKET = new TypedField<>(String.class, "market");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> TAXPAYER_TYPE = new TypedField<>(String.class, "taxpayerType");
        TypedField<String> IS_OPEN = new TypedField<>(String.class, "isOpen");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> JV_PC = new TypedField<>(String.class, "jvPc");
        TypedField<String> JV_CODE = new TypedField<>(String.class, "jvCode");
        TypedField<String> RMS_CODE = new TypedField<>(String.class, "rmsCode");
        TypedField<String> COMPANY_CODE = new TypedField<>(String.class, "companyCode");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyTaxNo");
        TypedField<String> MAIN_STORE = new TypedField<>(String.class, "mainStore");
        TypedField<String> ARCHIVAL_COVER = new TypedField<>(String.class, "archivalCover");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
    }
    public interface AccountManger {
        static Long id() {
            return 1640719722056040450L;
        }
        static String code() {
            return "accountManger";
        }
        TypedField<String> LEDGER = new TypedField<>(String.class, "ledger");
        TypedField<String> CATEGORY = new TypedField<>(String.class, "category");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> ACCOUNT_DATE = new TypedField<>(String.class, "accountDate");
        TypedField<String> COMPANY = new TypedField<>(String.class, "company");
        TypedField<String> NATURAL_ACCOUNT = new TypedField<>(String.class, "naturalAccount");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> PRODUCT_CODING = new TypedField<>(String.class, "productCoding");
        TypedField<String> SALES_CHANNEL = new TypedField<>(String.class, "salesChannel");
        TypedField<String> COUNTRY = new TypedField<>(String.class, "country");
        TypedField<String> INTER_COMPANY = new TypedField<>(String.class, "interCompany");
        TypedField<String> PROJECT = new TypedField<>(String.class, "project");
        TypedField<String> SPARE = new TypedField<>(String.class, "spare");
        TypedField<BigDecimal> DEBIT = new TypedField<>(BigDecimal.class, "debit");
        TypedField<BigDecimal> CREDIT = new TypedField<>(BigDecimal.class, "credit");
        TypedField<String> BATCH_NAME = new TypedField<>(String.class, "batchName");
        TypedField<String> BATCH_EXPLANATION = new TypedField<>(String.class, "batchExplanation");
        TypedField<String> JOURNAL_NAME = new TypedField<>(String.class, "journalName");
        TypedField<String> LINE_DESCRIPTION = new TypedField<>(String.class, "lineDescription");
        TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "documentType");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paperDrewDate");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> USER_CREATE_TIME = new TypedField<>(String.class, "userCreateTime");
        TypedField<String> USER_NAME = new TypedField<>(String.class, "userName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> GROUP_NAME = new TypedField<>(String.class, "groupName");
        TypedField<String> PERIOD = new TypedField<>(String.class, "period");
        TypedField<String> RMS_CODE = new TypedField<>(String.class, "rmsCode");
    }
    public interface FilterPurchaseInvoice {
        static Long id() {
            return 1640919046444552193L;
        }
        static String code() {
            return "filterPurchaseInvoice";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> DATE_ISSUED = new TypedField<>(String.class, "dateIssued");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<LocalDateTime> REVERSE_TIME = new TypedField<>(LocalDateTime.class, "reverseTime");
        TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterNumber");
        TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceKind");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface AffirmInvoice {
        static Long id() {
            return 1641014530535915521L;
        }
        static String code() {
            return "affirmInvoice";
        }
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> GROUP = new TypedField<>(String.class, "group");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> COST_CENTER = new TypedField<>(String.class, "costCenter");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paperDrewDate");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> ACCOUNT_STATUS = new TypedField<>(String.class, "accountStatus");
        TypedField<String> RISK_SOURCE = new TypedField<>(String.class, "riskSource");
        TypedField<LocalDateTime> SYNC_DATE = new TypedField<>(LocalDateTime.class, "syncDate");
        TypedField<LocalDateTime> VOUCHER_DATE = new TypedField<>(LocalDateTime.class, "voucherDate");
        TypedField<String> AFFIRM_CHANNEL = new TypedField<>(String.class, "affirmChannel");
        TypedField<Boolean> FLOW_STATUS = new TypedField<>(Boolean.class, "flowStatus");
        TypedField<Boolean> RISK_STATUS = new TypedField<>(Boolean.class, "riskStatus");
        TypedField<String> FAIL_MESSAGE = new TypedField<>(String.class, "failMessage");
        TypedField<String> SYNC_STATUS = new TypedField<>(String.class, "syncStatus");
        TypedField<String> VOUCHER_STATUS = new TypedField<>(String.class, "voucherStatus");
    }
    public interface SellerInfo {
        static Long id() {
            return 1643801672272580610L;
        }
        static String code() {
            return "sellerInfo";
        }
        TypedField<String> ABBREVIATION = new TypedField<>(String.class, "abbreviation");
        TypedField<Long> PRIORITY = new TypedField<>(Long.class, "priority");
        TypedField<String> GROUP = new TypedField<>(String.class, "group");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> CHANNEL = new TypedField<>(String.class, "channel");
    }
    public interface PeriodManger {
        static Long id() {
            return 1646091335671336962L;
        }
        static String code() {
            return "periodManger";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PERIOD_CODE = new TypedField<>(String.class, "periodCode");
        TypedField<LocalDateTime> PERIOD_START = new TypedField<>(LocalDateTime.class, "periodStart");
        TypedField<LocalDateTime> PERIOD_END = new TypedField<>(LocalDateTime.class, "periodEnd");
    }
    public interface GroupInfo {
        static Long id() {
            return 1647145450548559873L;
        }
        static String code() {
            return "groupInfo";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> GROUP_CODE = new TypedField<>(String.class, "groupCode");
        TypedField<String> GROUP_NAME = new TypedField<>(String.class, "groupName");
        TypedField<String> GROUP_TYPE = new TypedField<>(String.class, "groupType");
        TypedField<String> GROUP_DESC = new TypedField<>(String.class, "groupDesc");
        TypedField<String> NATURAL_CODE = new TypedField<>(String.class, "naturalCode");
        TypedField<String> NATURAL_NAME = new TypedField<>(String.class, "naturalName");
    }
    public interface Invoice {
        static Long id() {
            return 1647849935262978049L;
        }
        static String code() {
            return "invoice";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> HEADER_INFO = new TypedField<>(String.class, "headerInfo");
        TypedField<String> EXTENDED_ATTRS = new TypedField<>(String.class, "extendedAttrs");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "auditStatus");
        TypedField<String> BUSINESS_LABELS = new TypedField<>(String.class, "businessLabels");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "taxInvoiceSource");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> MATCH_FAILED_MESSAGE = new TypedField<>(String.class, "matchFailedMessage");
        TypedField<String> REJECT_MAN = new TypedField<>(String.class, "rejectMan");
        TypedField<String> REJECT_MESSAGE = new TypedField<>(String.class, "rejectMessage");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");
        TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceKind");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> BODY = new TypedField<>(String.class, "body");
        TypedField<Long> I_TENANT_ID = new TypedField<>(Long.class, "iTenantId");
        TypedField<String> BUYER_TENANT_CODE = new TypedField<>(String.class, "buyerTenantCode");
        TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "sellerTenantCode");
        TypedField<LocalDateTime> DATE_ISSUED = new TypedField<>(LocalDateTime.class, "dateIssued");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1647849935690797058L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> GOODS_TAX_NO_VERSION = new TypedField<>(String.class, "goodsTaxNoVersion");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> DEDUCTIONS = new TypedField<>(BigDecimal.class, "deductions");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_AND_INVOICE_DETAIL_RELATION_ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_AND_INVOICE_DETAIL_RELATION {
                static String code () {
                    return "invoiceAndInvoiceDetailRelation" ;
                }
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.invoiceNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.sellerTaxNo");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceAndInvoiceDetailRelation.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAndInvoiceDetailRelation.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAndInvoiceDetailRelation.amountWithoutTax");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.matchStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceAndInvoiceDetailRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceAndInvoiceDetailRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.delete_flag");
                TypedField<String> HEADER_INFO = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.headerInfo");
                TypedField<String> EXTENDED_ATTRS = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.extendedAttrs");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.auditStatus");
                TypedField<String> BUSINESS_LABELS = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.businessLabels");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.taxInvoiceSource");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.buyerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.buyerName");
                TypedField<String> MATCH_FAILED_MESSAGE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.matchFailedMessage");
                TypedField<String> REJECT_MAN = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.rejectMan");
                TypedField<String> REJECT_MESSAGE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.rejectMessage");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.serialNo");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.invoiceKind");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.type");
                TypedField<String> BODY = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.body");
                TypedField<Long> I_TENANT_ID = new TypedField<>(Long.class, "invoiceAndInvoiceDetailRelation.iTenantId");
                TypedField<String> BUYER_TENANT_CODE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.buyerTenantCode");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.sellerTenantCode");
                TypedField<LocalDateTime> DATE_ISSUED = new TypedField<>(LocalDateTime.class, "invoiceAndInvoiceDetailRelation.dateIssued");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceAndInvoiceDetailRelation.invoiceType");
            }
        }
    }
    public interface Log {
        static Long id() {
            return 1647849935858569218L;
        }
        static String code() {
            return "log";
        }
        TypedField<String> OPERATOR = new TypedField<>(String.class, "operator");
        TypedField<String> OPERATION_CONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RULE_ID = new TypedField<>(String.class, "ruleId");
        TypedField<String> HANDLE_TYPE = new TypedField<>(String.class, "handleType");
        TypedField<String> BUSINESS_NO = new TypedField<>(String.class, "businessNo");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<String> MATCH_FAILED_MESSAGE = new TypedField<>(String.class, "matchFailedMessage");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "auditStatus");
        TypedField<String> REJECT_MESSAGE = new TypedField<>(String.class, "rejectMessage");
        TypedField<String> REJECT_MAN = new TypedField<>(String.class, "rejectMan");
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operationTime");
        /**
         * 对一关联关系 关联对象 invoice
         */
        TypedField<Long> INVOICE_AND_LOG_RELATION_ID = new TypedField<>(Long.class, "invoiceAndLogRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_AND_LOG_RELATION {
                static String code () {
                    return "invoiceAndLogRelation" ;
                }
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceAndLogRelation.invoiceCode");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceAndLogRelation.invoiceNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceAndLogRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceAndLogRelation.sellerTaxNo");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceAndLogRelation.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceAndLogRelation.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceAndLogRelation.amountWithoutTax");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "invoiceAndLogRelation.matchStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceAndLogRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceAndLogRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceAndLogRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceAndLogRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceAndLogRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceAndLogRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceAndLogRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceAndLogRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceAndLogRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceAndLogRelation.delete_flag");
                TypedField<String> HEADER_INFO = new TypedField<>(String.class, "invoiceAndLogRelation.headerInfo");
                TypedField<String> EXTENDED_ATTRS = new TypedField<>(String.class, "invoiceAndLogRelation.extendedAttrs");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "invoiceAndLogRelation.auditStatus");
                TypedField<String> BUSINESS_LABELS = new TypedField<>(String.class, "invoiceAndLogRelation.businessLabels");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "invoiceAndLogRelation.taxInvoiceSource");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "invoiceAndLogRelation.buyerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "invoiceAndLogRelation.buyerName");
                TypedField<String> MATCH_FAILED_MESSAGE = new TypedField<>(String.class, "invoiceAndLogRelation.matchFailedMessage");
                TypedField<String> REJECT_MAN = new TypedField<>(String.class, "invoiceAndLogRelation.rejectMan");
                TypedField<String> REJECT_MESSAGE = new TypedField<>(String.class, "invoiceAndLogRelation.rejectMessage");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "invoiceAndLogRelation.serialNo");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceAndLogRelation.invoiceKind");
                TypedField<String> TYPE = new TypedField<>(String.class, "invoiceAndLogRelation.type");
                TypedField<String> BODY = new TypedField<>(String.class, "invoiceAndLogRelation.body");
                TypedField<Long> I_TENANT_ID = new TypedField<>(Long.class, "invoiceAndLogRelation.iTenantId");
                TypedField<String> BUYER_TENANT_CODE = new TypedField<>(String.class, "invoiceAndLogRelation.buyerTenantCode");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "invoiceAndLogRelation.sellerTenantCode");
                TypedField<LocalDateTime> DATE_ISSUED = new TypedField<>(LocalDateTime.class, "invoiceAndLogRelation.dateIssued");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceAndLogRelation.invoiceType");
            }
        }
    }
    public interface User {
        static Long id() {
            return 1650307242123071489L;
        }
        static String code() {
            return "user";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> AGE = new TypedField<>(Long.class, "age");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TEST = new TypedField<>(String.class, "test");
        TypedField<String> TEL = new TypedField<>(String.class, "tel");
    }
    public interface RedInvoiceDetail {
        static Long id() {
            return 1650418467592048642L;
        }
        static String code() {
            return "redInvoiceDetail";
        }
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> DEDUCTION = new TypedField<>(String.class, "deduction");
        TypedField<String> GOODS_TAX_NO_VERSION = new TypedField<>(String.class, "goodsTaxNoVersion");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unitPriceWithTax");
        TypedField<Long> ORIGIN_INVOICE_ROW_NUM = new TypedField<>(Long.class, "originInvoiceRowNum");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "itemTypeCode");
        /**
         * 对一关联关系 关联对象 redInformationManage
         */
        TypedField<Long> RED_INFORMATION_AND_DETAILS_RELATION_ID = new TypedField<>(Long.class, "redInformationAndDetailsRelation.id");
        /**
         * 对一关联关系 关联对象 redLetterManage
         */
        TypedField<Long> RED_LETTER_AND_DETAILS_RELATION_ID = new TypedField<>(Long.class, "redLetterAndDetailsRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface RED_INFORMATION_AND_DETAILS_RELATION {
                static String code () {
                    return "redInformationAndDetailsRelation" ;
                }
                TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "redInformationAndDetailsRelation.accountType");
                TypedField<String> APPLY_SERIAL_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.applySerialNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "redInformationAndDetailsRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "redInformationAndDetailsRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.buyerTaxNo");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "redInformationAndDetailsRelation.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redInformationAndDetailsRelation.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "redInformationAndDetailsRelation.taxAmount");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "redInformationAndDetailsRelation.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "redInformationAndDetailsRelation.originalInvoiceType");
                TypedField<String> APPLYING_STATUS = new TypedField<>(String.class, "redInformationAndDetailsRelation.applyingStatus");
                TypedField<String> BUSINESS_REMARK = new TypedField<>(String.class, "redInformationAndDetailsRelation.businessRemark");
                TypedField<String> APPLY_TAX_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.applyTaxNo");
                TypedField<String> RED_INFO_URL = new TypedField<>(String.class, "redInformationAndDetailsRelation.redInfoUrl");
                TypedField<String> RED_INVOICE_CODE = new TypedField<>(String.class, "redInformationAndDetailsRelation.redInvoiceCode");
                TypedField<String> RED_INVOICE_NO = new TypedField<>(String.class, "redInformationAndDetailsRelation.redInvoiceNo");
                TypedField<LocalDateTime> RED_PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "redInformationAndDetailsRelation.redPaperDrewDate");
                TypedField<String> RED_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redInformationAndDetailsRelation.redAmountWithoutTax");
                TypedField<String> RED_TAX_AMOUNT = new TypedField<>(String.class, "redInformationAndDetailsRelation.redTaxAmount");
                TypedField<String> RED_AMOUNT_WITH_TAX = new TypedField<>(String.class, "redInformationAndDetailsRelation.redAmountWithTax");
                TypedField<LocalDateTime> RED_RECOVERY_DATE = new TypedField<>(LocalDateTime.class, "redInformationAndDetailsRelation.redRecoveryDate");
                TypedField<String> RED_DIFFERENCES_REASON = new TypedField<>(String.class, "redInformationAndDetailsRelation.redDifferencesReason");
                TypedField<String> APPLY_STATUS = new TypedField<>(String.class, "redInformationAndDetailsRelation.applyStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "redInformationAndDetailsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "redInformationAndDetailsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "redInformationAndDetailsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "redInformationAndDetailsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "redInformationAndDetailsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "redInformationAndDetailsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "redInformationAndDetailsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "redInformationAndDetailsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "redInformationAndDetailsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "redInformationAndDetailsRelation.delete_flag");
                TypedField<String> TERMINAL_UN = new TypedField<>(String.class, "redInformationAndDetailsRelation.terminalUn");
                TypedField<String> DEVICE_UN = new TypedField<>(String.class, "redInformationAndDetailsRelation.deviceUn");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "redInformationAndDetailsRelation.applyReason");
                TypedField<String> SYSTEN_ORIGN = new TypedField<>(String.class, "redInformationAndDetailsRelation.systenOrign");
                TypedField<String> RED_LETTER_REASON = new TypedField<>(String.class, "redInformationAndDetailsRelation.redLetterReason");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "redInformationAndDetailsRelation.originalDateIssued");
            }
            interface RED_LETTER_AND_DETAILS_RELATION {
                static String code () {
                    return "redLetterAndDetailsRelation" ;
                }
                TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "redLetterAndDetailsRelation.accountType");
                TypedField<String> CUSTOMER_SERIAL_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.customerSerialNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "redLetterAndDetailsRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "redLetterAndDetailsRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.buyerTaxNo");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "redLetterAndDetailsRelation.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redLetterAndDetailsRelation.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "redLetterAndDetailsRelation.taxAmount");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "redLetterAndDetailsRelation.pricingMethod");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "redLetterAndDetailsRelation.originalInvoiceType");
                TypedField<String> ORIGINAL_ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.originalAllElectricInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "redLetterAndDetailsRelation.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.originalInvoiceNo");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "redLetterAndDetailsRelation.applyReason");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterAndDetailsRelation.redLetterNumber");
                TypedField<String> APPLY_STATUS = new TypedField<>(String.class, "redLetterAndDetailsRelation.applyStatus");
                TypedField<String> BUSINESS_REMARK = new TypedField<>(String.class, "redLetterAndDetailsRelation.businessRemark");
                TypedField<String> RED_INVOICE_CODE = new TypedField<>(String.class, "redLetterAndDetailsRelation.redInvoiceCode");
                TypedField<String> RED_INVOICE_NO = new TypedField<>(String.class, "redLetterAndDetailsRelation.redInvoiceNo");
                TypedField<LocalDateTime> RED_PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "redLetterAndDetailsRelation.redPaperDrewDate");
                TypedField<String> RED_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redLetterAndDetailsRelation.redAmountWithoutTax");
                TypedField<String> RED_TAX_AMOUNT = new TypedField<>(String.class, "redLetterAndDetailsRelation.redTaxAmount");
                TypedField<String> RED_AMOUNT_WITH_TAX = new TypedField<>(String.class, "redLetterAndDetailsRelation.redAmountWithTax");
                TypedField<LocalDateTime> RED_RECOVERY_DATE = new TypedField<>(LocalDateTime.class, "redLetterAndDetailsRelation.redRecoveryDate");
                TypedField<String> RED_DIFFERENCES_REASON = new TypedField<>(String.class, "redLetterAndDetailsRelation.redDifferencesReason");
                TypedField<Long> ID = new TypedField<>(Long.class, "redLetterAndDetailsRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "redLetterAndDetailsRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "redLetterAndDetailsRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "redLetterAndDetailsRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "redLetterAndDetailsRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "redLetterAndDetailsRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "redLetterAndDetailsRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "redLetterAndDetailsRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "redLetterAndDetailsRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "redLetterAndDetailsRelation.delete_flag");
                TypedField<String> SYSTEM_ORIGIN = new TypedField<>(String.class, "redLetterAndDetailsRelation.systemOrigin");
                TypedField<String> RED_LETTER_REASON = new TypedField<>(String.class, "redLetterAndDetailsRelation.redLetterReason");
            }
        }
    }
    public interface SpecialAdditions {
        static Long id() {
            return 1650430361480564738L;
        }
        static String code() {
            return "specialAdditions";
        }
        TypedField<String> TOOL_TYPE = new TypedField<>(String.class, "toolType");
        TypedField<String> TOOL_BRAND = new TypedField<>(String.class, "toolBrand");
        TypedField<String> NAME_OF_GOODS = new TypedField<>(String.class, "nameOfGoods");
        TypedField<String> PLACE_OF_SHIPMENT = new TypedField<>(String.class, "placeOfShipment");
        TypedField<String> DESTINATION = new TypedField<>(String.class, "destination");
        TypedField<String> PLACE_OF_OCCURRENCE = new TypedField<>(String.class, "placeOfOccurrence");
        TypedField<String> ENTRY_NAME = new TypedField<>(String.class, "entryName");
        TypedField<String> PLACE = new TypedField<>(String.class, "place");
        TypedField<String> REAL_ESTATE_CODE = new TypedField<>(String.class, "realEstateCode");
        TypedField<String> TAXABLE_PRICE = new TypedField<>(String.class, "taxablePrice");
        TypedField<String> TRANSACTION_PRICE = new TypedField<>(String.class, "transactionPrice");
        TypedField<String> LEASE_TERM_START = new TypedField<>(String.class, "leaseTermStart");
        TypedField<String> LEASE_TERM_END = new TypedField<>(String.class, "leaseTermEnd");
        TypedField<Boolean> CROSS_CITY_SIGN = new TypedField<>(Boolean.class, "crossCitySign");
        TypedField<String> LAND_VAT_ITEM_NO = new TypedField<>(String.class, "landVatItemNo");
        TypedField<String> REAL_ESTATE_NO = new TypedField<>(String.class, "realEstateNo");
        TypedField<String> REAL_ESTATE_ADDRESS = new TypedField<>(String.class, "realEstateAddress");
        TypedField<String> AREA_UNIT = new TypedField<>(String.class, "areaUnit");
        TypedField<String> REAL_ESTATE_PLACE = new TypedField<>(String.class, "realEstatePlace");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface RedFollow {
        static Long id() {
            return 1650435128634703873L;
        }
        static String code() {
            return "redFollow";
        }
        TypedField<String> RED_INVOICE_CODE = new TypedField<>(String.class, "redInvoiceCode");
        TypedField<String> RED_INVOICE_NO = new TypedField<>(String.class, "redInvoiceNo");
        TypedField<LocalDateTime> RED_PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "redPaperDrewDate");
        TypedField<BigDecimal> RED_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "redAmountWithoutTax");
        TypedField<BigDecimal> RED_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "redTaxAmount");
        TypedField<BigDecimal> RED_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "redAmountWithTax");
        TypedField<LocalDateTime> RED_RECOVERY_DATE = new TypedField<>(LocalDateTime.class, "redRecoveryDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RED_DIFFERENCES_REASON = new TypedField<>(String.class, "redDifferencesReason");
    }
    public interface ExamineManage {
        static Long id() {
            return 1650764853269336066L;
        }
        static String code() {
            return "examineManage";
        }
        TypedField<String> WORKFLOW_TYPE = new TypedField<>(String.class, "workflowType");
        TypedField<String> APPLY_NAME = new TypedField<>(String.class, "applyName");
        TypedField<String> APPLY_NO = new TypedField<>(String.class, "applyNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> APPLY_USER = new TypedField<>(String.class, "applyUser");
        TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "applyTime");
        TypedField<String> APPLY_REASON = new TypedField<>(String.class, "applyReason");
        TypedField<String> WORKFLOW_STATUS = new TypedField<>(String.class, "workflowStatus");
        TypedField<String> END_TYPE = new TypedField<>(String.class, "endType");
        TypedField<String> END_REMARK = new TypedField<>(String.class, "endRemark");
        TypedField<String> UPLOAD_FAIL_REASON = new TypedField<>(String.class, "uploadFailReason");
        TypedField<String> AUDITING_USER = new TypedField<>(String.class, "auditingUser");
        TypedField<LocalDateTime> AUDITING_TIME = new TypedField<>(LocalDateTime.class, "auditingTime");
        TypedField<String> EXAMINE_USER = new TypedField<>(String.class, "examineUser");
        TypedField<LocalDateTime> EXAMINE_TIME = new TypedField<>(LocalDateTime.class, "examineTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> HISTORY_RED_LETTER_NUMBER = new TypedField<>(String.class, "historyRedLetterNumber");
        TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "applyBatchNum");
        TypedField<Long> APPLY_USER_ID = new TypedField<>(Long.class, "applyUserId");
        TypedField<Long> AUDITING_USER_ID = new TypedField<>(Long.class, "auditingUserId");
        TypedField<Long> EXAMINE_USER_ID = new TypedField<>(Long.class, "examineUserId");
        TypedField<String> AUDITING_USER_EMAIL = new TypedField<>(String.class, "auditingUserEmail");
        TypedField<String> EXAMINE_USER_EMAIL = new TypedField<>(String.class, "examineUserEmail");
        TypedField<String> APPLY_GROUP = new TypedField<>(String.class, "applyGroup");
        TypedField<String> EXAMINE_GROUP = new TypedField<>(String.class, "examineGroup");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Test111 {
        static Long id() {
            return 1651851798495440897L;
        }
        static String code() {
            return "test111";
        }
        TypedField<String> TEST_NAME = new TypedField<>(String.class, "test_name");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface RedLetterManage {
        static Long id() {
            return 1653949151460261890L;
        }
        static String code() {
            return "redLetterManage";
        }
        TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "accountType");
        TypedField<String> CUSTOMER_SERIAL_NO = new TypedField<>(String.class, "customerSerialNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "pricingMethod");
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> ORIGINAL_ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "originalAllElectricInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> APPLY_REASON = new TypedField<>(String.class, "applyReason");
        TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterNumber");
        TypedField<String> APPLY_STATUS = new TypedField<>(String.class, "applyStatus");
        TypedField<String> BUSINESS_REMARK = new TypedField<>(String.class, "businessRemark");
        TypedField<String> RED_INVOICE_CODE = new TypedField<>(String.class, "redInvoiceCode");
        TypedField<String> RED_INVOICE_NO = new TypedField<>(String.class, "redInvoiceNo");
        TypedField<LocalDateTime> RED_PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "redPaperDrewDate");
        TypedField<String> RED_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redAmountWithoutTax");
        TypedField<String> RED_TAX_AMOUNT = new TypedField<>(String.class, "redTaxAmount");
        TypedField<String> RED_AMOUNT_WITH_TAX = new TypedField<>(String.class, "redAmountWithTax");
        TypedField<LocalDateTime> RED_RECOVERY_DATE = new TypedField<>(LocalDateTime.class, "redRecoveryDate");
        TypedField<String> RED_DIFFERENCES_REASON = new TypedField<>(String.class, "redDifferencesReason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SYSTEM_ORIGIN = new TypedField<>(String.class, "systemOrigin");
        TypedField<String> RED_LETTER_REASON = new TypedField<>(String.class, "redLetterReason");
        /**
         * 对一关联关系 关联对象 examineManage
         */
        TypedField<Long> EXAMINE_AND_RED_LETTER_RELATION_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface EXAMINE_AND_RED_LETTER_RELATION {
                static String code () {
                    return "examineAndRedLetterRelation" ;
                }
                TypedField<String> WORKFLOW_TYPE = new TypedField<>(String.class, "examineAndRedLetterRelation.workflowType");
                TypedField<String> APPLY_NAME = new TypedField<>(String.class, "examineAndRedLetterRelation.applyName");
                TypedField<String> APPLY_NO = new TypedField<>(String.class, "examineAndRedLetterRelation.applyNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "examineAndRedLetterRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "examineAndRedLetterRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "examineAndRedLetterRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "examineAndRedLetterRelation.buyerTaxNo");
                TypedField<String> APPLY_USER = new TypedField<>(String.class, "examineAndRedLetterRelation.applyUser");
                TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedLetterRelation.applyTime");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "examineAndRedLetterRelation.applyReason");
                TypedField<String> WORKFLOW_STATUS = new TypedField<>(String.class, "examineAndRedLetterRelation.workflowStatus");
                TypedField<String> END_TYPE = new TypedField<>(String.class, "examineAndRedLetterRelation.endType");
                TypedField<String> END_REMARK = new TypedField<>(String.class, "examineAndRedLetterRelation.endRemark");
                TypedField<String> UPLOAD_FAIL_REASON = new TypedField<>(String.class, "examineAndRedLetterRelation.uploadFailReason");
                TypedField<String> AUDITING_USER = new TypedField<>(String.class, "examineAndRedLetterRelation.auditingUser");
                TypedField<LocalDateTime> AUDITING_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedLetterRelation.auditingTime");
                TypedField<String> EXAMINE_USER = new TypedField<>(String.class, "examineAndRedLetterRelation.examineUser");
                TypedField<LocalDateTime> EXAMINE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedLetterRelation.examineTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "examineAndRedLetterRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedLetterRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedLetterRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "examineAndRedLetterRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "examineAndRedLetterRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "examineAndRedLetterRelation.delete_flag");
                TypedField<String> HISTORY_RED_LETTER_NUMBER = new TypedField<>(String.class, "examineAndRedLetterRelation.historyRedLetterNumber");
                TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "examineAndRedLetterRelation.applyBatchNum");
                TypedField<Long> APPLY_USER_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.applyUserId");
                TypedField<Long> AUDITING_USER_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.auditingUserId");
                TypedField<Long> EXAMINE_USER_ID = new TypedField<>(Long.class, "examineAndRedLetterRelation.examineUserId");
                TypedField<String> AUDITING_USER_EMAIL = new TypedField<>(String.class, "examineAndRedLetterRelation.auditingUserEmail");
                TypedField<String> EXAMINE_USER_EMAIL = new TypedField<>(String.class, "examineAndRedLetterRelation.examineUserEmail");
                TypedField<String> APPLY_GROUP = new TypedField<>(String.class, "examineAndRedLetterRelation.applyGroup");
                TypedField<String> EXAMINE_GROUP = new TypedField<>(String.class, "examineAndRedLetterRelation.examineGroup");
            }
        }
    }
    public interface RedInformationManage {
        static Long id() {
            return 1653966498985226242L;
        }
        static String code() {
            return "redInformationManage";
        }
        TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "accountType");
        TypedField<String> APPLY_SERIAL_NO = new TypedField<>(String.class, "applySerialNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> APPLYING_STATUS = new TypedField<>(String.class, "applyingStatus");
        TypedField<String> BUSINESS_REMARK = new TypedField<>(String.class, "businessRemark");
        TypedField<String> APPLY_TAX_NO = new TypedField<>(String.class, "applyTaxNo");
        TypedField<String> RED_INFO_URL = new TypedField<>(String.class, "redInfoUrl");
        TypedField<String> RED_INVOICE_CODE = new TypedField<>(String.class, "redInvoiceCode");
        TypedField<String> RED_INVOICE_NO = new TypedField<>(String.class, "redInvoiceNo");
        TypedField<LocalDateTime> RED_PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "redPaperDrewDate");
        TypedField<String> RED_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "redAmountWithoutTax");
        TypedField<String> RED_TAX_AMOUNT = new TypedField<>(String.class, "redTaxAmount");
        TypedField<String> RED_AMOUNT_WITH_TAX = new TypedField<>(String.class, "redAmountWithTax");
        TypedField<LocalDateTime> RED_RECOVERY_DATE = new TypedField<>(LocalDateTime.class, "redRecoveryDate");
        TypedField<String> RED_DIFFERENCES_REASON = new TypedField<>(String.class, "redDifferencesReason");
        TypedField<String> APPLY_STATUS = new TypedField<>(String.class, "applyStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TERMINAL_UN = new TypedField<>(String.class, "terminalUn");
        TypedField<String> DEVICE_UN = new TypedField<>(String.class, "deviceUn");
        TypedField<String> APPLY_REASON = new TypedField<>(String.class, "applyReason");
        TypedField<String> SYSTEN_ORIGN = new TypedField<>(String.class, "systenOrign");
        TypedField<String> RED_LETTER_REASON = new TypedField<>(String.class, "redLetterReason");
        TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalDateIssued");
        /**
         * 对一关联关系 关联对象 examineManage
         */
        TypedField<Long> EXAMINE_AND_RED_INFORMATION_RELATION_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface EXAMINE_AND_RED_INFORMATION_RELATION {
                static String code () {
                    return "examineAndRedInformationRelation" ;
                }
                TypedField<String> WORKFLOW_TYPE = new TypedField<>(String.class, "examineAndRedInformationRelation.workflowType");
                TypedField<String> APPLY_NAME = new TypedField<>(String.class, "examineAndRedInformationRelation.applyName");
                TypedField<String> APPLY_NO = new TypedField<>(String.class, "examineAndRedInformationRelation.applyNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "examineAndRedInformationRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "examineAndRedInformationRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "examineAndRedInformationRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "examineAndRedInformationRelation.buyerTaxNo");
                TypedField<String> APPLY_USER = new TypedField<>(String.class, "examineAndRedInformationRelation.applyUser");
                TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedInformationRelation.applyTime");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "examineAndRedInformationRelation.applyReason");
                TypedField<String> WORKFLOW_STATUS = new TypedField<>(String.class, "examineAndRedInformationRelation.workflowStatus");
                TypedField<String> END_TYPE = new TypedField<>(String.class, "examineAndRedInformationRelation.endType");
                TypedField<String> END_REMARK = new TypedField<>(String.class, "examineAndRedInformationRelation.endRemark");
                TypedField<String> UPLOAD_FAIL_REASON = new TypedField<>(String.class, "examineAndRedInformationRelation.uploadFailReason");
                TypedField<String> AUDITING_USER = new TypedField<>(String.class, "examineAndRedInformationRelation.auditingUser");
                TypedField<LocalDateTime> AUDITING_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedInformationRelation.auditingTime");
                TypedField<String> EXAMINE_USER = new TypedField<>(String.class, "examineAndRedInformationRelation.examineUser");
                TypedField<LocalDateTime> EXAMINE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedInformationRelation.examineTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "examineAndRedInformationRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedInformationRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndRedInformationRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "examineAndRedInformationRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "examineAndRedInformationRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "examineAndRedInformationRelation.delete_flag");
                TypedField<String> HISTORY_RED_LETTER_NUMBER = new TypedField<>(String.class, "examineAndRedInformationRelation.historyRedLetterNumber");
                TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "examineAndRedInformationRelation.applyBatchNum");
                TypedField<Long> APPLY_USER_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.applyUserId");
                TypedField<Long> AUDITING_USER_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.auditingUserId");
                TypedField<Long> EXAMINE_USER_ID = new TypedField<>(Long.class, "examineAndRedInformationRelation.examineUserId");
                TypedField<String> AUDITING_USER_EMAIL = new TypedField<>(String.class, "examineAndRedInformationRelation.auditingUserEmail");
                TypedField<String> EXAMINE_USER_EMAIL = new TypedField<>(String.class, "examineAndRedInformationRelation.examineUserEmail");
                TypedField<String> APPLY_GROUP = new TypedField<>(String.class, "examineAndRedInformationRelation.applyGroup");
                TypedField<String> EXAMINE_GROUP = new TypedField<>(String.class, "examineAndRedInformationRelation.examineGroup");
            }
        }
    }
    public interface AttachmentManage {
        static Long id() {
            return 1654023011764899841L;
        }
        static String code() {
            return "attachmentManage";
        }
        TypedField<String> ATTACHMENT_NAME = new TypedField<>(String.class, "attachmentName");
        TypedField<String> ATTACHMENT_URL = new TypedField<>(String.class, "attachmentUrl");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 examineManage
         */
        TypedField<Long> EXAMINE_AND_ATTACHMENT_RELATION_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface EXAMINE_AND_ATTACHMENT_RELATION {
                static String code () {
                    return "examineAndAttachmentRelation" ;
                }
                TypedField<String> WORKFLOW_TYPE = new TypedField<>(String.class, "examineAndAttachmentRelation.workflowType");
                TypedField<String> APPLY_NAME = new TypedField<>(String.class, "examineAndAttachmentRelation.applyName");
                TypedField<String> APPLY_NO = new TypedField<>(String.class, "examineAndAttachmentRelation.applyNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "examineAndAttachmentRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "examineAndAttachmentRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "examineAndAttachmentRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "examineAndAttachmentRelation.buyerTaxNo");
                TypedField<String> APPLY_USER = new TypedField<>(String.class, "examineAndAttachmentRelation.applyUser");
                TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "examineAndAttachmentRelation.applyTime");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "examineAndAttachmentRelation.applyReason");
                TypedField<String> WORKFLOW_STATUS = new TypedField<>(String.class, "examineAndAttachmentRelation.workflowStatus");
                TypedField<String> END_TYPE = new TypedField<>(String.class, "examineAndAttachmentRelation.endType");
                TypedField<String> END_REMARK = new TypedField<>(String.class, "examineAndAttachmentRelation.endRemark");
                TypedField<String> UPLOAD_FAIL_REASON = new TypedField<>(String.class, "examineAndAttachmentRelation.uploadFailReason");
                TypedField<String> AUDITING_USER = new TypedField<>(String.class, "examineAndAttachmentRelation.auditingUser");
                TypedField<LocalDateTime> AUDITING_TIME = new TypedField<>(LocalDateTime.class, "examineAndAttachmentRelation.auditingTime");
                TypedField<String> EXAMINE_USER = new TypedField<>(String.class, "examineAndAttachmentRelation.examineUser");
                TypedField<LocalDateTime> EXAMINE_TIME = new TypedField<>(LocalDateTime.class, "examineAndAttachmentRelation.examineTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "examineAndAttachmentRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndAttachmentRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndAttachmentRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "examineAndAttachmentRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "examineAndAttachmentRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "examineAndAttachmentRelation.delete_flag");
                TypedField<String> HISTORY_RED_LETTER_NUMBER = new TypedField<>(String.class, "examineAndAttachmentRelation.historyRedLetterNumber");
                TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "examineAndAttachmentRelation.applyBatchNum");
                TypedField<Long> APPLY_USER_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.applyUserId");
                TypedField<Long> AUDITING_USER_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.auditingUserId");
                TypedField<Long> EXAMINE_USER_ID = new TypedField<>(Long.class, "examineAndAttachmentRelation.examineUserId");
                TypedField<String> AUDITING_USER_EMAIL = new TypedField<>(String.class, "examineAndAttachmentRelation.auditingUserEmail");
                TypedField<String> EXAMINE_USER_EMAIL = new TypedField<>(String.class, "examineAndAttachmentRelation.examineUserEmail");
                TypedField<String> APPLY_GROUP = new TypedField<>(String.class, "examineAndAttachmentRelation.applyGroup");
                TypedField<String> EXAMINE_GROUP = new TypedField<>(String.class, "examineAndAttachmentRelation.examineGroup");
            }
        }
    }
    public interface WorkflowOperateManage {
        static Long id() {
            return 1654034007196237826L;
        }
        static String code() {
            return "workflowOperateManage";
        }
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operateType");
        TypedField<String> OPERATE_REASON = new TypedField<>(String.class, "operateReason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 examineManage
         */
        TypedField<Long> EXAMINE_AND_OPERATE_RELATION_ID = new TypedField<>(Long.class, "examineAndOperateRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface EXAMINE_AND_OPERATE_RELATION {
                static String code () {
                    return "examineAndOperateRelation" ;
                }
                TypedField<String> WORKFLOW_TYPE = new TypedField<>(String.class, "examineAndOperateRelation.workflowType");
                TypedField<String> APPLY_NAME = new TypedField<>(String.class, "examineAndOperateRelation.applyName");
                TypedField<String> APPLY_NO = new TypedField<>(String.class, "examineAndOperateRelation.applyNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "examineAndOperateRelation.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "examineAndOperateRelation.sellerTaxNo");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "examineAndOperateRelation.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "examineAndOperateRelation.buyerTaxNo");
                TypedField<String> APPLY_USER = new TypedField<>(String.class, "examineAndOperateRelation.applyUser");
                TypedField<LocalDateTime> APPLY_TIME = new TypedField<>(LocalDateTime.class, "examineAndOperateRelation.applyTime");
                TypedField<String> APPLY_REASON = new TypedField<>(String.class, "examineAndOperateRelation.applyReason");
                TypedField<String> WORKFLOW_STATUS = new TypedField<>(String.class, "examineAndOperateRelation.workflowStatus");
                TypedField<String> END_TYPE = new TypedField<>(String.class, "examineAndOperateRelation.endType");
                TypedField<String> END_REMARK = new TypedField<>(String.class, "examineAndOperateRelation.endRemark");
                TypedField<String> UPLOAD_FAIL_REASON = new TypedField<>(String.class, "examineAndOperateRelation.uploadFailReason");
                TypedField<String> AUDITING_USER = new TypedField<>(String.class, "examineAndOperateRelation.auditingUser");
                TypedField<LocalDateTime> AUDITING_TIME = new TypedField<>(LocalDateTime.class, "examineAndOperateRelation.auditingTime");
                TypedField<String> EXAMINE_USER = new TypedField<>(String.class, "examineAndOperateRelation.examineUser");
                TypedField<LocalDateTime> EXAMINE_TIME = new TypedField<>(LocalDateTime.class, "examineAndOperateRelation.examineTime");
                TypedField<Long> ID = new TypedField<>(Long.class, "examineAndOperateRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "examineAndOperateRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "examineAndOperateRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndOperateRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "examineAndOperateRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "examineAndOperateRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "examineAndOperateRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "examineAndOperateRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "examineAndOperateRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "examineAndOperateRelation.delete_flag");
                TypedField<String> HISTORY_RED_LETTER_NUMBER = new TypedField<>(String.class, "examineAndOperateRelation.historyRedLetterNumber");
                TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "examineAndOperateRelation.applyBatchNum");
                TypedField<Long> APPLY_USER_ID = new TypedField<>(Long.class, "examineAndOperateRelation.applyUserId");
                TypedField<Long> AUDITING_USER_ID = new TypedField<>(Long.class, "examineAndOperateRelation.auditingUserId");
                TypedField<Long> EXAMINE_USER_ID = new TypedField<>(Long.class, "examineAndOperateRelation.examineUserId");
                TypedField<String> AUDITING_USER_EMAIL = new TypedField<>(String.class, "examineAndOperateRelation.auditingUserEmail");
                TypedField<String> EXAMINE_USER_EMAIL = new TypedField<>(String.class, "examineAndOperateRelation.examineUserEmail");
                TypedField<String> APPLY_GROUP = new TypedField<>(String.class, "examineAndOperateRelation.applyGroup");
                TypedField<String> EXAMINE_GROUP = new TypedField<>(String.class, "examineAndOperateRelation.examineGroup");
            }
        }
    }
    public interface RedExcelImport {
        static Long id() {
            return 1655757591684960257L;
        }
        static String code() {
            return "redExcelImport";
        }
        TypedField<String> APPLY_BATCH_NUM = new TypedField<>(String.class, "applyBatchNum");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> APPLY_TYPE = new TypedField<>(String.class, "applyType");
        TypedField<String> APPLY_REASON = new TypedField<>(String.class, "applyReason");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unitPriceWithTax");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalDateIssued");
        TypedField<String> BUSINESS_REMARK = new TypedField<>(String.class, "businessRemark");
    }
}
