package com.xforceplus.ultraman.app.jcwatsons.metadata.validator;

import com.xforceplus.ultraman.app.jcwatsons.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcwatsons.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(TaxpayerType.class)) {
            isValid = null != TaxpayerType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxpayerType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOpen.class)) {
            isValid = null != IsOpen.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsOpen.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentType.class)) {
            isValid = null != DocumentType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocumentType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = null != InvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = null != ReverseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = null != AuthStyle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = null != AuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = null != InvoiceStyleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = null != SpecialType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = null != TurnOutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = null != TurnOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AgentIssuedFlag.class)) {
            isValid = null != AgentIssuedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AgentIssuedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = null != HandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskSource.class)) {
            isValid = null != RiskSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AffirmChannel.class)) {
            isValid = null != AffirmChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AffirmChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerSource.class)) {
            isValid = null != SellerSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerSource.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(GroupType.class)) {
            isValid = null != GroupType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GroupType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlushWorkflowType.class)) {
            isValid = null != RedFlushWorkflowType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedFlushWorkflowType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncStatus.class)) {
            isValid = null != SyncStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VoucherStatus.class)) {
            isValid = null != VoucherStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VoucherStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Test.class)) {
            isValid = null != Test.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Test.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = null != ItemTypeCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(ToolType.class)) {
            isValid = null != ToolType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ToolType.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = null != AreaUnit.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EndType.class)) {
            isValid = null != EndType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EndType.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = null != PricingMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(RedLetterReason.class)) {
            isValid = null != RedLetterReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedLetterReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = null != ApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyingStatus.class)) {
            isValid = null != ApplyingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InfomationApplyStatus.class)) {
            isValid = null != InfomationApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InfomationApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OperateType.class)) {
            isValid = null != OperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyReason.class)) {
            isValid = null != ApplyReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(Group.class)) {
            isValid = null != Group.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Group.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
