package com.xforceplus.ultraman.app.jcwatsons.metadata.validator;

import com.xforceplus.ultraman.app.jcwatsons.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcwatsons.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(TaxpayerType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxpayerType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxpayerType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOpen.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsOpen.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsOpen.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReverseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStyle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStyleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AgentIssuedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AgentIssuedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AgentIssuedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AffirmChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AffirmChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AffirmChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerSource.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(GroupType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GroupType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GroupType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlushWorkflowType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedFlushWorkflowType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedFlushWorkflowType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SyncStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VoucherStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VoucherStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VoucherStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Test.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Test.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Test.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemTypeCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(ToolType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ToolType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ToolType.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AreaUnit.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EndType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EndType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EndType.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PricingMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(RedLetterReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedLetterReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedLetterReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InfomationApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InfomationApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InfomationApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OperateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OperateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(Group.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Group.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Group.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
