package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.AuditingUserObj;
import com.xforceplus.ultraman.app.jcwatsons.service.IAuditingUserObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class AuditingUserObjController {

  @Autowired
  private IAuditingUserObjService auditingUserObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param auditingUserObj ${table.comment}
   * @return
   */
  @GetMapping("/auditinguserobjs" )
  public XfR getAuditingUserObjs(XfPage page, AuditingUserObj auditingUserObj) {
    return XfR.ok(auditingUserObjServiceImpl.page(page, Wrappers.query(auditingUserObj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/auditinguserobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(auditingUserObjServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param auditingUserObj ${table.comment}
   * @return XfR
   */
  @PostMapping("/auditinguserobjs")
  public XfR save(@RequestBody AuditingUserObj auditingUserObj) {
     return XfR.ok(auditingUserObjServiceImpl.save(auditingUserObj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param auditingUserObj ${table.comment}
   * @return XfR
   */
  @PutMapping("/auditinguserobjs/{id}")
  public XfR putUpdate(@RequestBody AuditingUserObj auditingUserObj,@PathVariable Long id) {
      auditingUserObj.setId(id);
      return XfR.ok(auditingUserObjServiceImpl.updateById(auditingUserObj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param auditingUserObj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/auditinguserobjs/{id}")
  public XfR patchUpdate(@RequestBody AuditingUserObj auditingUserObj,@PathVariable Long id) {
      AuditingUserObj upauditingUserObj = auditingUserObjServiceImpl.getById(id);
      if(upauditingUserObj != null){
        upauditingUserObj = ObjectCopyUtils.copyProperties(auditingUserObj,upauditingUserObj,true);
      }
      return XfR.ok(auditingUserObjServiceImpl.updateById(upauditingUserObj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/auditinguserobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(auditingUserObjServiceImpl.removeById(id));
  }

  @PostMapping("/auditinguserobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "auditing_user_obj");
     params.put("request", condition);

     return XfR.ok(auditingUserObjServiceImpl.querys(params));
  }

}
