package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.ExamineGroupObj;
import com.xforceplus.ultraman.app.jcwatsons.service.IExamineGroupObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class ExamineGroupObjController {

  @Autowired
  private IExamineGroupObjService examineGroupObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param examineGroupObj ${table.comment}
   * @return
   */
  @GetMapping("/examinegroupobjs" )
  public XfR getExamineGroupObjs(XfPage page, ExamineGroupObj examineGroupObj) {
    return XfR.ok(examineGroupObjServiceImpl.page(page, Wrappers.query(examineGroupObj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/examinegroupobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(examineGroupObjServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param examineGroupObj ${table.comment}
   * @return XfR
   */
  @PostMapping("/examinegroupobjs")
  public XfR save(@RequestBody ExamineGroupObj examineGroupObj) {
     return XfR.ok(examineGroupObjServiceImpl.save(examineGroupObj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param examineGroupObj ${table.comment}
   * @return XfR
   */
  @PutMapping("/examinegroupobjs/{id}")
  public XfR putUpdate(@RequestBody ExamineGroupObj examineGroupObj,@PathVariable Long id) {
      examineGroupObj.setId(id);
      return XfR.ok(examineGroupObjServiceImpl.updateById(examineGroupObj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param examineGroupObj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/examinegroupobjs/{id}")
  public XfR patchUpdate(@RequestBody ExamineGroupObj examineGroupObj,@PathVariable Long id) {
      ExamineGroupObj upexamineGroupObj = examineGroupObjServiceImpl.getById(id);
      if(upexamineGroupObj != null){
        upexamineGroupObj = ObjectCopyUtils.copyProperties(examineGroupObj,upexamineGroupObj,true);
      }
      return XfR.ok(examineGroupObjServiceImpl.updateById(upexamineGroupObj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/examinegroupobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(examineGroupObjServiceImpl.removeById(id));
  }

  @PostMapping("/examinegroupobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "examine_group_obj");
     params.put("request", condition);

     return XfR.ok(examineGroupObjServiceImpl.querys(params));
  }

}
