package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.ExamineObj;
import com.xforceplus.ultraman.app.jcwatsons.service.IExamineObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 提交审批的对象前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class ExamineObjController {

  @Autowired
  private IExamineObjService examineObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param examineObj 提交审批的对象
   * @return
   */
  @GetMapping("/examineobjs" )
  public XfR getExamineObjs(XfPage page, ExamineObj examineObj) {
    return XfR.ok(examineObjServiceImpl.page(page, Wrappers.query(examineObj)));
  }

  /**
   * 通过id查询提交审批的对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/examineobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(examineObjServiceImpl.getById(id));
  }

  /**
   * 新增提交审批的对象
   * @param examineObj 提交审批的对象
   * @return XfR
   */
  @PostMapping("/examineobjs")
  public XfR save(@RequestBody ExamineObj examineObj) {
     return XfR.ok(examineObjServiceImpl.save(examineObj));
  }

  /**
   * 修改-传入修改后的全部数据提交审批的对象
   * @param examineObj 提交审批的对象
   * @return XfR
   */
  @PutMapping("/examineobjs/{id}")
  public XfR putUpdate(@RequestBody ExamineObj examineObj,@PathVariable Long id) {
      examineObj.setId(id);
      return XfR.ok(examineObjServiceImpl.updateById(examineObj));
  }

  /**
   * 修改-传入修改的数据提交审批的对象
   * @param examineObj 提交审批的对象
   * @return XfR
   */
  @PatchMapping("/examineobjs/{id}")
  public XfR patchUpdate(@RequestBody ExamineObj examineObj,@PathVariable Long id) {
      ExamineObj upexamineObj = examineObjServiceImpl.getById(id);
      if(upexamineObj != null){
        upexamineObj = ObjectCopyUtils.copyProperties(examineObj,upexamineObj,true);
      }
      return XfR.ok(examineObjServiceImpl.updateById(upexamineObj));
  }

  /**
   * 通过id删除提交审批的对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/examineobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(examineObjServiceImpl.removeById(id));
  }

  @PostMapping("/examineobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "examine_obj");
     params.put("request", condition);

     return XfR.ok(examineObjServiceImpl.querys(params));
  }

}
