package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.ExamineUserObj;
import com.xforceplus.ultraman.app.jcwatsons.service.IExamineUserObjService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class ExamineUserObjController {

  @Autowired
  private IExamineUserObjService examineUserObjServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param examineUserObj 
   * @return
   */
  @GetMapping("/examineuserobjs" )
  public XfR getExamineUserObjs(XfPage page, ExamineUserObj examineUserObj) {
    return XfR.ok(examineUserObjServiceImpl.page(page, Wrappers.query(examineUserObj)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/examineuserobjs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(examineUserObjServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param examineUserObj 
   * @return XfR
   */
  @PostMapping("/examineuserobjs")
  public XfR save(@RequestBody ExamineUserObj examineUserObj) {
     return XfR.ok(examineUserObjServiceImpl.save(examineUserObj));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param examineUserObj 
   * @return XfR
   */
  @PutMapping("/examineuserobjs/{id}")
  public XfR putUpdate(@RequestBody ExamineUserObj examineUserObj,@PathVariable Long id) {
      examineUserObj.setId(id);
      return XfR.ok(examineUserObjServiceImpl.updateById(examineUserObj));
  }

  /**
   * 修改-传入修改的数据
   * @param examineUserObj 
   * @return XfR
   */
  @PatchMapping("/examineuserobjs/{id}")
  public XfR patchUpdate(@RequestBody ExamineUserObj examineUserObj,@PathVariable Long id) {
      ExamineUserObj upexamineUserObj = examineUserObjServiceImpl.getById(id);
      if(upexamineUserObj != null){
        upexamineUserObj = ObjectCopyUtils.copyProperties(examineUserObj,upexamineUserObj,true);
      }
      return XfR.ok(examineUserObjServiceImpl.updateById(upexamineUserObj));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/examineuserobjs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(examineUserObjServiceImpl.removeById(id));
  }

  @PostMapping("/examineuserobjs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "examine_user_obj");
     params.put("request", condition);

     return XfR.ok(examineUserObjServiceImpl.querys(params));
  }

}
