package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.Log;
import com.xforceplus.ultraman.app.jcwatsons.service.ILogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 日志表前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class LogController {

  @Autowired
  private ILogService logServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param log 日志表
   * @return
   */
  @GetMapping("/logs" )
  public XfR getLogs(XfPage page, Log log) {
    return XfR.ok(logServiceImpl.page(page, Wrappers.query(log)));
  }

  /**
   * 通过id查询日志表
   * @param  id
   * @return XfR
   */
  @GetMapping("/logs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(logServiceImpl.getById(id));
  }

  /**
   * 新增日志表
   * @param log 日志表
   * @return XfR
   */
  @PostMapping("/logs")
  public XfR save(@RequestBody Log log) {
     return XfR.ok(logServiceImpl.save(log));
  }

  /**
   * 修改-传入修改后的全部数据日志表
   * @param log 日志表
   * @return XfR
   */
  @PutMapping("/logs/{id}")
  public XfR putUpdate(@RequestBody Log log,@PathVariable Long id) {
      log.setId(id);
      return XfR.ok(logServiceImpl.updateById(log));
  }

  /**
   * 修改-传入修改的数据日志表
   * @param log 日志表
   * @return XfR
   */
  @PatchMapping("/logs/{id}")
  public XfR patchUpdate(@RequestBody Log log,@PathVariable Long id) {
      Log uplog = logServiceImpl.getById(id);
      if(uplog != null){
        uplog = ObjectCopyUtils.copyProperties(log,uplog,true);
      }
      return XfR.ok(logServiceImpl.updateById(uplog));
  }

  /**
   * 通过id删除日志表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/logs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(logServiceImpl.removeById(id));
  }

  @PostMapping("/logs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "log");
     params.put("request", condition);

     return XfR.ok(logServiceImpl.querys(params));
  }

}
