package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.PeriodManger;
import com.xforceplus.ultraman.app.jcwatsons.service.IPeriodMangerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class PeriodMangerController {

  @Autowired
  private IPeriodMangerService periodMangerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param periodManger ${table.comment}
   * @return
   */
  @GetMapping("/periodmangers" )
  public XfR getPeriodMangers(XfPage page, PeriodManger periodManger) {
    return XfR.ok(periodMangerServiceImpl.page(page, Wrappers.query(periodManger)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/periodmangers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(periodMangerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param periodManger ${table.comment}
   * @return XfR
   */
  @PostMapping("/periodmangers")
  public XfR save(@RequestBody PeriodManger periodManger) {
     return XfR.ok(periodMangerServiceImpl.save(periodManger));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param periodManger ${table.comment}
   * @return XfR
   */
  @PutMapping("/periodmangers/{id}")
  public XfR putUpdate(@RequestBody PeriodManger periodManger,@PathVariable Long id) {
      periodManger.setId(id);
      return XfR.ok(periodMangerServiceImpl.updateById(periodManger));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param periodManger ${table.comment}
   * @return XfR
   */
  @PatchMapping("/periodmangers/{id}")
  public XfR patchUpdate(@RequestBody PeriodManger periodManger,@PathVariable Long id) {
      PeriodManger upperiodManger = periodMangerServiceImpl.getById(id);
      if(upperiodManger != null){
        upperiodManger = ObjectCopyUtils.copyProperties(periodManger,upperiodManger,true);
      }
      return XfR.ok(periodMangerServiceImpl.updateById(upperiodManger));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/periodmangers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(periodMangerServiceImpl.removeById(id));
  }

  @PostMapping("/periodmangers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "period_manger");
     params.put("request", condition);

     return XfR.ok(periodMangerServiceImpl.querys(params));
  }

}
