package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.RedExcelImport;
import com.xforceplus.ultraman.app.jcwatsons.service.IRedExcelImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class RedExcelImportController {

  @Autowired
  private IRedExcelImportService redExcelImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redExcelImport ${table.comment}
   * @return
   */
  @GetMapping("/redexcelimports" )
  public XfR getRedExcelImports(XfPage page, RedExcelImport redExcelImport) {
    return XfR.ok(redExcelImportServiceImpl.page(page, Wrappers.query(redExcelImport)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redexcelimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redExcelImportServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redExcelImport ${table.comment}
   * @return XfR
   */
  @PostMapping("/redexcelimports")
  public XfR save(@RequestBody RedExcelImport redExcelImport) {
     return XfR.ok(redExcelImportServiceImpl.save(redExcelImport));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redExcelImport ${table.comment}
   * @return XfR
   */
  @PutMapping("/redexcelimports/{id}")
  public XfR putUpdate(@RequestBody RedExcelImport redExcelImport,@PathVariable Long id) {
      redExcelImport.setId(id);
      return XfR.ok(redExcelImportServiceImpl.updateById(redExcelImport));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redExcelImport ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redexcelimports/{id}")
  public XfR patchUpdate(@RequestBody RedExcelImport redExcelImport,@PathVariable Long id) {
      RedExcelImport upredExcelImport = redExcelImportServiceImpl.getById(id);
      if(upredExcelImport != null){
        upredExcelImport = ObjectCopyUtils.copyProperties(redExcelImport,upredExcelImport,true);
      }
      return XfR.ok(redExcelImportServiceImpl.updateById(upredExcelImport));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redexcelimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redExcelImportServiceImpl.removeById(id));
  }

  @PostMapping("/redexcelimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_excel_import");
     params.put("request", condition);

     return XfR.ok(redExcelImportServiceImpl.querys(params));
  }

}
