package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.RedLetterManage;
import com.xforceplus.ultraman.app.jcwatsons.service.IRedLetterManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class RedLetterManageController {

  @Autowired
  private IRedLetterManageService redLetterManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterManage ${table.comment}
   * @return
   */
  @GetMapping("/redlettermanages" )
  public XfR getRedLetterManages(XfPage page, RedLetterManage redLetterManage) {
    return XfR.ok(redLetterManageServiceImpl.page(page, Wrappers.query(redLetterManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redlettermanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/redlettermanages")
  public XfR save(@RequestBody RedLetterManage redLetterManage) {
     return XfR.ok(redLetterManageServiceImpl.save(redLetterManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/redlettermanages/{id}")
  public XfR putUpdate(@RequestBody RedLetterManage redLetterManage,@PathVariable Long id) {
      redLetterManage.setId(id);
      return XfR.ok(redLetterManageServiceImpl.updateById(redLetterManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redlettermanages/{id}")
  public XfR patchUpdate(@RequestBody RedLetterManage redLetterManage,@PathVariable Long id) {
      RedLetterManage upredLetterManage = redLetterManageServiceImpl.getById(id);
      if(upredLetterManage != null){
        upredLetterManage = ObjectCopyUtils.copyProperties(redLetterManage,upredLetterManage,true);
      }
      return XfR.ok(redLetterManageServiceImpl.updateById(upredLetterManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redlettermanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterManageServiceImpl.removeById(id));
  }

  @PostMapping("/redlettermanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_manage");
     params.put("request", condition);

     return XfR.ok(redLetterManageServiceImpl.querys(params));
  }

}
