package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.SellerInfo;
import com.xforceplus.ultraman.app.jcwatsons.service.ISellerInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class SellerInfoController {

  @Autowired
  private ISellerInfoService sellerInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return
   */
  @GetMapping("/sellerinfos" )
  public XfR getSellerInfos(XfPage page, SellerInfo sellerInfo) {
    return XfR.ok(sellerInfoServiceImpl.page(page, Wrappers.query(sellerInfo)));
  }

  /**
   * 通过id查询存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInfoServiceImpl.getById(id));
  }

  /**
   * 新增存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return XfR
   */
  @PostMapping("/sellerinfos")
  public XfR save(@RequestBody SellerInfo sellerInfo) {
     return XfR.ok(sellerInfoServiceImpl.save(sellerInfo));
  }

  /**
   * 修改-传入修改后的全部数据存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return XfR
   */
  @PutMapping("/sellerinfos/{id}")
  public XfR putUpdate(@RequestBody SellerInfo sellerInfo,@PathVariable Long id) {
      sellerInfo.setId(id);
      return XfR.ok(sellerInfoServiceImpl.updateById(sellerInfo));
  }

  /**
   * 修改-传入修改的数据存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param sellerInfo 存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @return XfR
   */
  @PatchMapping("/sellerinfos/{id}")
  public XfR patchUpdate(@RequestBody SellerInfo sellerInfo,@PathVariable Long id) {
      SellerInfo upsellerInfo = sellerInfoServiceImpl.getById(id);
      if(upsellerInfo != null){
        upsellerInfo = ObjectCopyUtils.copyProperties(sellerInfo,upsellerInfo,true);
      }
      return XfR.ok(sellerInfoServiceImpl.updateById(upsellerInfo));
  }

  /**
   * 通过id删除存储rental同步过来的销方信息（仅有销方名称），和通过导入Excel维护的Tax销方信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInfoServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_info");
     params.put("request", condition);

     return XfR.ok(sellerInfoServiceImpl.querys(params));
  }

}
