package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.Test111;
import com.xforceplus.ultraman.app.jcwatsons.service.ITest111Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 测试一下前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class Test111Controller {

  @Autowired
  private ITest111Service test111ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test111 测试一下
   * @return
   */
  @GetMapping("/test111s" )
  public XfR getTest111s(XfPage page, Test111 test111) {
    return XfR.ok(test111ServiceImpl.page(page, Wrappers.query(test111)));
  }

  /**
   * 通过id查询测试一下
   * @param  id
   * @return XfR
   */
  @GetMapping("/test111s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test111ServiceImpl.getById(id));
  }

  /**
   * 新增测试一下
   * @param test111 测试一下
   * @return XfR
   */
  @PostMapping("/test111s")
  public XfR save(@RequestBody Test111 test111) {
     return XfR.ok(test111ServiceImpl.save(test111));
  }

  /**
   * 修改-传入修改后的全部数据测试一下
   * @param test111 测试一下
   * @return XfR
   */
  @PutMapping("/test111s/{id}")
  public XfR putUpdate(@RequestBody Test111 test111,@PathVariable Long id) {
      test111.setId(id);
      return XfR.ok(test111ServiceImpl.updateById(test111));
  }

  /**
   * 修改-传入修改的数据测试一下
   * @param test111 测试一下
   * @return XfR
   */
  @PatchMapping("/test111s/{id}")
  public XfR patchUpdate(@RequestBody Test111 test111,@PathVariable Long id) {
      Test111 uptest111 = test111ServiceImpl.getById(id);
      if(uptest111 != null){
        uptest111 = ObjectCopyUtils.copyProperties(test111,uptest111,true);
      }
      return XfR.ok(test111ServiceImpl.updateById(uptest111));
  }

  /**
   * 通过id删除测试一下
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test111s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test111ServiceImpl.removeById(id));
  }

  @PostMapping("/test111s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test111");
     params.put("request", condition);

     return XfR.ok(test111ServiceImpl.querys(params));
  }

}
