package com.xforceplus.ultraman.app.jcwatsons.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.User;
import com.xforceplus.ultraman.app.jcwatsons.service.IUserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 用户前端控制器
 *
 * @author ultraman
 * @date 2023-05-18
 */
@RestController
public class UserController {

  @Autowired
  private IUserService userServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param user 用户
   * @return
   */
  @GetMapping("/users" )
  public XfR getUsers(XfPage page, User user) {
    return XfR.ok(userServiceImpl.page(page, Wrappers.query(user)));
  }

  /**
   * 通过id查询用户
   * @param  id
   * @return XfR
   */
  @GetMapping("/users/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userServiceImpl.getById(id));
  }

  /**
   * 新增用户
   * @param user 用户
   * @return XfR
   */
  @PostMapping("/users")
  public XfR save(@RequestBody User user) {
     return XfR.ok(userServiceImpl.save(user));
  }

  /**
   * 修改-传入修改后的全部数据用户
   * @param user 用户
   * @return XfR
   */
  @PutMapping("/users/{id}")
  public XfR putUpdate(@RequestBody User user,@PathVariable Long id) {
      user.setId(id);
      return XfR.ok(userServiceImpl.updateById(user));
  }

  /**
   * 修改-传入修改的数据用户
   * @param user 用户
   * @return XfR
   */
  @PatchMapping("/users/{id}")
  public XfR patchUpdate(@RequestBody User user,@PathVariable Long id) {
      User upuser = userServiceImpl.getById(id);
      if(upuser != null){
        upuser = ObjectCopyUtils.copyProperties(user,upuser,true);
      }
      return XfR.ok(userServiceImpl.updateById(upuser));
  }

  /**
   * 通过id删除用户
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/users/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userServiceImpl.removeById(id));
  }

  @PostMapping("/users/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user");
     params.put("request", condition);

     return XfR.ok(userServiceImpl.querys(params));
  }

}
