package com.xforceplus.ultraman.app.jcxuhuiant.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票申请类型
 * </p>
 *
 * @author ultraman
 * @since 2022-04-25
 */
public enum ApplyType {

    A("A", "工程类"),
    B("B", "非工程类");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApplyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyType fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            default:
                return null;
        }
    }
}
