package com.xforceplus.ultraman.app.jcxuhuiant.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 合同名称
   */
  @TableField("contractName")
  private String contractName;

  /**
   * 收款单位
   */
  @TableField("payeeName")
  private String payeeName;

  /**
   * 付款单位
   */
  @TableField("paymentUnitName")
  private String paymentUnitName;

  /**
   * 合同最新总金额
   */
  @TableField("contractNewAmount")
  private BigDecimal contractNewAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 合同金额
   */
  @TableField("contractAmount")
  private BigDecimal contractAmount;

  /**
   * 项目编号
   */
  @TableField("entryNo")
  private String entryNo;

  /**
   * 项目名称
   */
  @TableField("entryName")
  private String entryName;

  /**
   * 项目地址
   */
  @TableField("entryAddr")
  private String entryAddr;

  /**
   * 收款单位
   */
  @TableField("paymentUnit")
  private String paymentUnit;

  /**
   * 收款单位编号
   */
  @TableField("paymentUnitNo")
  private String paymentUnitNo;

  /**
   * 合同开票申请金额
   */
  @TableField("contractApplyAmount")
  private String contractApplyAmount;

  /**
   * 合同开票申请剩余金额
   */
  @TableField("contractApplySurplusAmount")
  private BigDecimal contractApplySurplusAmount;

  /**
   * 合同已开累计发票金额
   */
  @TableField("contractOpenedInvoiceAmount")
  private BigDecimal contractOpenedInvoiceAmount;

  /**
   * 合同已支付金额
   */
  @TableField("contractPaymentAmount")
  private BigDecimal contractPaymentAmount;

  /**
   * 合同支付比例
   */
  @TableField("contractPaymentProportion")
  private String contractPaymentProportion;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("contractName", contractName);
      map.put("payeeName", payeeName);
      map.put("paymentUnitName", paymentUnitName);
      map.put("contractNewAmount", contractNewAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractType", contractType);
      map.put("contractAmount", contractAmount);
      map.put("entryNo", entryNo);
      map.put("entryName", entryName);
      map.put("entryAddr", entryAddr);
      map.put("paymentUnit", paymentUnit);
      map.put("paymentUnitNo", paymentUnitNo);
      map.put("contractApplyAmount", contractApplyAmount);
      map.put("contractApplySurplusAmount", contractApplySurplusAmount);
      map.put("contractOpenedInvoiceAmount", contractOpenedInvoiceAmount);
      map.put("contractPaymentAmount", contractPaymentAmount);
      map.put("contractPaymentProportion", contractPaymentProportion);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeName")) {
      Object obj = map.get("payeeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnitName")) {
      Object obj = map.get("paymentUnitName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNewAmount")) {
      Object obj = map.get("contractNewAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractNewAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractNewAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractNewAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractNewAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractNewAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractAmount")) {
      Object obj = map.get("contractAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("entryNo")) {
      Object obj = map.get("entryNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryName")) {
      Object obj = map.get("entryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryAddr")) {
      Object obj = map.get("entryAddr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnit")) {
      Object obj = map.get("paymentUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnitNo")) {
      Object obj = map.get("paymentUnitNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnitNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractApplyAmount")) {
      Object obj = map.get("contractApplyAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractApplyAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractApplySurplusAmount")) {
      Object obj = map.get("contractApplySurplusAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractApplySurplusAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractApplySurplusAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractApplySurplusAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractApplySurplusAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractApplySurplusAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractOpenedInvoiceAmount")) {
      Object obj = map.get("contractOpenedInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractOpenedInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractOpenedInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractOpenedInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractOpenedInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractOpenedInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractPaymentAmount")) {
      Object obj = map.get("contractPaymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setContractPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setContractPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setContractPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setContractPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setContractPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("contractPaymentProportion")) {
      Object obj = map.get("contractPaymentProportion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractPaymentProportion((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
