package com.xforceplus.ultraman.app.jcxuhuiant.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceApply implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 开票申请编号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 开票申请类型
   */
  @TableField("applyType")
  private String applyType;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 合同名称
   */
  @TableField("contractName")
  private String contractName;

  /**
   * 合同类型
   */
  @TableField("contractType")
  private String contractType;

  /**
   * 合同最新总金额
   */
  @TableField("contractNewAmount")
  private String contractNewAmount;

  /**
   * 项目名称
   */
  @TableField("entryName")
  private String entryName;

  /**
   * 项目编号
   */
  @TableField("entryNo")
  private String entryNo;

  /**
   * 项目地址
   */
  @TableField("entryAddr")
  private String entryAddr;

  /**
   * 收款单位编号
   */
  @TableField("payeeNo")
  private String payeeNo;

  /**
   * 收款单位名称
   */
  @TableField("payeeName")
  private String payeeName;

  /**
   * 收款单位税号
   */
  @TableField("payeeTaxNo")
  private String payeeTaxNo;

  /**
   * 付款单位编号
   */
  @TableField("paymentUnitNo")
  private String paymentUnitNo;

  /**
   * 付款单位名称
   */
  @TableField("paymentUnitName")
  private String paymentUnitName;

  /**
   * 付款单位税号
   */
  @TableField("paymentUnitTaxNo")
  private String paymentUnitTaxNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 经办日期
   */
  @TableField("handlingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime handlingDate;

  /**
   * 经办人
   */
  private String handler;

  /**
   * 本次开票金额
   */
  @TableField("invoiceAmount")
  private String invoiceAmount;

  /**
   * 本次已开票金额
   */
  @TableField("alreadyInvoiceAmount")
  private String alreadyInvoiceAmount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 申请单状态
   */
  private String status;

  /**
   * 剩余开票金额
   */
  @TableField("surplusInvoiceAmount")
  private String surplusInvoiceAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyNo", applyNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyType", applyType);
      map.put("contractNo", contractNo);
      map.put("contractName", contractName);
      map.put("contractType", contractType);
      map.put("contractNewAmount", contractNewAmount);
      map.put("entryName", entryName);
      map.put("entryNo", entryNo);
      map.put("entryAddr", entryAddr);
      map.put("payeeNo", payeeNo);
      map.put("payeeName", payeeName);
      map.put("payeeTaxNo", payeeTaxNo);
      map.put("paymentUnitNo", paymentUnitNo);
      map.put("paymentUnitName", paymentUnitName);
      map.put("paymentUnitTaxNo", paymentUnitTaxNo);
      map.put("invoiceType", invoiceType);
      map.put("handlingDate", BocpGenUtils.toTimestamp(handlingDate));
      map.put("handler", handler);
      map.put("invoiceAmount", invoiceAmount);
      map.put("alreadyInvoiceAmount", alreadyInvoiceAmount);
      map.put("remark", remark);
      map.put("status", status);
      map.put("surplusInvoiceAmount", surplusInvoiceAmount);
      return map;
  }

  public static InvoiceApply fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceApply entity = new InvoiceApply();
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyType")) {
      Object obj = map.get("applyType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractName")) {
      Object obj = map.get("contractName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractType")) {
      Object obj = map.get("contractType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNewAmount")) {
      Object obj = map.get("contractNewAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNewAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryName")) {
      Object obj = map.get("entryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryNo")) {
      Object obj = map.get("entryNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryAddr")) {
      Object obj = map.get("entryAddr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntryAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeNo")) {
      Object obj = map.get("payeeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeName")) {
      Object obj = map.get("payeeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payeeTaxNo")) {
      Object obj = map.get("payeeTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayeeTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnitNo")) {
      Object obj = map.get("paymentUnitNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnitNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnitName")) {
      Object obj = map.get("paymentUnitName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentUnitTaxNo")) {
      Object obj = map.get("paymentUnitTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentUnitTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handlingDate")) {
      Object obj = map.get("handlingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHandlingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setHandlingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setHandlingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHandlingDate(null);
      }
    }
    if(map.containsKey("handler")) {
      Object obj = map.get("handler");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandler((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alreadyInvoiceAmount")) {
      Object obj = map.get("alreadyInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAlreadyInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("surplusInvoiceAmount")) {
      Object obj = map.get("surplusInvoiceAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSurplusInvoiceAmount((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
