package com.xforceplus.ultraman.app.jcyangolocal.controller;


/**
 * 流程实例日志feign客户端
 *
 * @author ultraman
 * @date 2024-06-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcyangolocal.entity.FlowInstanceLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-yango-local")
public interface FlowInstanceLogFeignApi {

  /**
   * 通过id查询流程实例日志
   * @param  id
   * @return R
   */
  @GetMapping("/flowInstanceLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增流程实例日志
   * @param flowInstanceLog 流程实例日志
   * @return R
   */
  @PostMapping("/flowInstanceLog/add")
  public R save(@RequestBody FlowInstanceLog flowInstanceLog);

  /**
   * 修改流程实例日志
   * @param flowInstanceLog 流程实例日志
   * @return R
   */
  @PostMapping("/flowInstanceLog/update")
  public R updateById(@RequestBody FlowInstanceLog flowInstanceLog);

  /**
   * 通过id删除流程实例日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/flowInstanceLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}