package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * identify_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
public enum IdentifyStatusEnum {

    _1("1", "已转出"),
    _2("2", "已认证"),
    _0("0", "未认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IdentifyStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IdentifyStatusEnum fromCode(String code) {
        return Stream.of(IdentifyStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
