package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
public enum TaxInvoiceSourceEnum {

    QD("qd", "全电发票 "),
    SK("sk", "税控发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSourceEnum fromCode(String code) {
        return Stream.of(TaxInvoiceSourceEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
