package com.xforceplus.ultraman.app.jcyangolocal.metadata.validator;

import com.xforceplus.ultraman.app.jcyangolocal.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcyangolocal.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-05-28
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatusEnum.class)) {
            isValid = null != DataStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AbandonFlagEnum.class)) {
            isValid = null != AbandonFlagEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AbandonFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillTypeEnum.class)) {
            isValid = null != BusinessBillTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessBillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusEnum.class)) {
            isValid = null != HandleStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IdentifyStatusEnum.class)) {
            isValid = null != IdentifyStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IdentifyStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColorEnum.class)) {
            isValid = null != InvoiceColorEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColorEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockFlagEnum.class)) {
            isValid = null != LockFlagEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatusEnum.class)) {
            isValid = null != PaymentStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PrintStatusEnum.class)) {
            isValid = null != PrintStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PrintStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = null != RedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatusEnum.class)) {
            isValid = null != RedStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatusEnum.class)) {
            isValid = null != VeriStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VeriStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSourceEnum.class)) {
            isValid = null != TaxInvoiceSourceEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSourceEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlagEnum.class)) {
            isValid = null != SpecialInvoiceFlagEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = null != InvoiceStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFlagEnum.class)) {
            isValid = null != IssueFlagEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IssueFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatusEnums.class)) {
            isValid = null != LockStatusEnums.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatusEnums.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyleEnum.class)) {
            isValid = null != AuthStyleEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStyleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatusEnum.class)) {
            isValid = null != AuthStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatusEnum.class)) {
            isValid = null != VerifyStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatusEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
