package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * abandon_flag_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum AbandonFlagEnum {

    _0("0", "默认"),
    _1("1", "批次内"),
    _2("2", "批次外");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AbandonFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AbandonFlagEnum fromCode(String code) {
        return Stream.of(AbandonFlagEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
