package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_color_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum InvoiceColorEnum {

    _1("1", "蓝票"),
    _2("2", "红票"),
    _3("3", "红冲票（红冲蓝票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceColorEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceColorEnum fromCode(String code) {
        return Stream.of(InvoiceColorEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
