package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * lock_flag_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum LockFlagEnum {

    _1("1", "已锁定"),
    _0("0", "未锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LockFlagEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LockFlagEnum fromCode(String code) {
        return Stream.of(LockFlagEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
