package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * lock_status_enums
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum LockStatusEnums {

    Y("Y", "锁定"),
    N("N", "未锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LockStatusEnums(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LockStatusEnums fromCode(String code) {
        return Stream.of(LockStatusEnums.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
