package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * payment_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-11
 */
public enum PaymentStatusEnum {

    _0("0", "未付款(默认)"),
    _1("1", "部分付款"),
    _2("2", "已付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaymentStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentStatusEnum fromCode(String code) {
        return Stream.of(PaymentStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
