package com.xforceplus.ultraman.app.jcyangolocal.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * buyer_invoice_details
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BuyerInvoiceDetails implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 货物代码
   */
  private String cargoCode;
  /**
   * 货物及服务名称
   */
  private String cargoName;
  /**
   * 规格型号
   */
  private String itemSpec;
  /**
   * 数量
   */
  private String quantity;
  /**
   * 单位
   */
  private String quantityUnit;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 单价
   */
  private String unitPrice;
  /**
   * 税额	
   */
  private String taxAmount;
  /**
   * 含税金额
   */
  private String amountWithTax;
  /**
   * 不含税金额
   */
  private String amountWithoutTax;
  /**
   * 零税率标志
   */
  private String taxRateType;
  /**
   * 通行日期起
   */
  private String tollStartDate;
  /**
   * 通行日期止
   */
  private String tollEndDate;
  /**
   * 车牌号
   */
  private String plateNumber;
  /**
   * 车辆类型
   */
  private String vehicleType;
  /**
   * 折扣不含税总额
   */
  private String discountWithoutTax;
  /**
   * 折扣税额
   */
  private String discountTax;
  /**
   * 折扣含税金额
   */
  private String discountWithTax;
  /**
   * 折扣税率
   */
  private String discountRate;
  /**
   * 商品税目
   */
  private String taxItem;
  /**
   * 税编版本号
   */
  private String goodsNoVer;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 商品编号
   */
  private String goodsErpNo;
  /**
   * 税收优惠政策
   */
  private String taxPreFlag;
  /**
   * 享受税收优惠政策内容
   */
  private String taxPreContent;
  /**
   * 扣除额
   */
  private String taxDedunction;
  /**
   * 折扣行标志
   */
  private String discountFlag;
  /**
   * 价格方式
   */
  private String priceMethod;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 buyerInvoiceMain
   */
  private Long buyerInvoiceMainOrBuyerInvoiceDetailsId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("cargoCode", cargoCode);
      map.put("cargoName", cargoName);
      map.put("itemSpec", itemSpec);
      map.put("quantity", quantity);
      map.put("quantityUnit", quantityUnit);
      map.put("taxRate", taxRate);
      map.put("unitPrice", unitPrice);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxRateType", taxRateType);
      map.put("tollStartDate", tollStartDate);
      map.put("tollEndDate", tollEndDate);
      map.put("plateNumber", plateNumber);
      map.put("vehicleType", vehicleType);
      map.put("discountWithoutTax", discountWithoutTax);
      map.put("discountTax", discountTax);
      map.put("discountWithTax", discountWithTax);
      map.put("discountRate", discountRate);
      map.put("taxItem", taxItem);
      map.put("goodsNoVer", goodsNoVer);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("goodsErpNo", goodsErpNo);
      map.put("taxPreFlag", taxPreFlag);
      map.put("taxPreContent", taxPreContent);
      map.put("taxDedunction", taxDedunction);
      map.put("discountFlag", discountFlag);
      map.put("priceMethod", priceMethod);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("buyerInvoiceMainOrBuyerInvoiceDetails.id", buyerInvoiceMainOrBuyerInvoiceDetailsId);
      return map;
  }

  public static BuyerInvoiceDetails fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    BuyerInvoiceDetails entity = new BuyerInvoiceDetails();

    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRateType")) {
      Object obj = map.get("taxRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollStartDate")) {
      Object obj = map.get("tollStartDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTollStartDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollEndDate")) {
      Object obj = map.get("tollEndDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTollEndDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plateNumber")) {
      Object obj = map.get("plateNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlateNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountWithoutTax")) {
      Object obj = map.get("discountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTax")) {
      Object obj = map.get("discountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountWithTax")) {
      Object obj = map.get("discountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxItem")) {
      Object obj = map.get("taxItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsErpNo")) {
      Object obj = map.get("goodsErpNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsErpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreFlag")) {
      Object obj = map.get("taxPreFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreContent")) {
      Object obj = map.get("taxPreContent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDedunction")) {
      Object obj = map.get("taxDedunction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxDedunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("buyerInvoiceMainOrBuyerInvoiceDetails.id")) {
       Object obj = map.get("buyerInvoiceMainOrBuyerInvoiceDetails.id");
       if(obj instanceof Long) {
         entity.setBuyerInvoiceMainOrBuyerInvoiceDetailsId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBuyerInvoiceMainOrBuyerInvoiceDetailsId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("cargoCode")) {
      Object obj = map.get("cargoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRateType")) {
      Object obj = map.get("taxRateType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollStartDate")) {
      Object obj = map.get("tollStartDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTollStartDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tollEndDate")) {
      Object obj = map.get("tollEndDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTollEndDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plateNumber")) {
      Object obj = map.get("plateNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPlateNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountWithoutTax")) {
      Object obj = map.get("discountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountTax")) {
      Object obj = map.get("discountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountWithTax")) {
      Object obj = map.get("discountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxItem")) {
      Object obj = map.get("taxItem");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsNoVer")) {
      Object obj = map.get("goodsNoVer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsErpNo")) {
      Object obj = map.get("goodsErpNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsErpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreFlag")) {
      Object obj = map.get("taxPreFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPreFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreContent")) {
      Object obj = map.get("taxPreContent");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPreContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDedunction")) {
      Object obj = map.get("taxDedunction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxDedunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountFlag")) {
      Object obj = map.get("discountFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceMethod")) {
      Object obj = map.get("priceMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("buyerInvoiceMainOrBuyerInvoiceDetails.id")) {
    Object obj = map.get("buyerInvoiceMainOrBuyerInvoiceDetails.id");
    if(obj instanceof Long) {
        this.setBuyerInvoiceMainOrBuyerInvoiceDetailsId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBuyerInvoiceMainOrBuyerInvoiceDetailsId(Long.parseLong((String)obj));
    }
  }
  }
}
