package com.xforceplus.ultraman.app.jcyangolocal.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * op_company_book_relation
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OpCompanyBookRelation implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 账套编号
   */
  private String accountBookCode;
  /**
   * 账套名称
   */
  private String accountBookName;
  /**
   * 法人公司主键
   */
  private String fCompanyID;
  /**
   * 法人公司编号
   */
  private String fCompanyCode;
  /**
   * 法人公司名称
   */
  private String fCompanyName;
  /**
   * 状态 1代表有效  0代表无效
   */
  private String dataStatus;
  /**
   * 同步来源
   */
  private String syncSource;
  /**
   * 备用字段1
   */
  private String f1;
  /**
   * 备用字段2
   */
  private String f2;
  /**
   * 备用字段3
   */
  private String f3;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * sendName
   */
  private String sendName;
  /**
   * businessTypeID
   */
  private String businessTypeID;
  /**
   * businessTypeCode
   */
  private String businessTypeCode;
  /**
   * businessTypeName
   */
  private String businessTypeName;
  /**
   * sendPurchaserName
   */
  private String sendPurchaserName;
  /**
   * sendMeikeName
   */
  private String sendMeikeName;
  /**
   * 送货单客户信息
   */
  private String sendInOutNameTel;
  /**
   * companyNature
   */
  private String companyNature;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("accountBookCode", accountBookCode);
      map.put("accountBookName", accountBookName);
      map.put("fCompanyID", fCompanyID);
      map.put("fCompanyCode", fCompanyCode);
      map.put("fCompanyName", fCompanyName);
      map.put("dataStatus", dataStatus);
      map.put("syncSource", syncSource);
      map.put("f1", f1);
      map.put("f2", f2);
      map.put("f3", f3);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sendName", sendName);
      map.put("businessTypeID", businessTypeID);
      map.put("businessTypeCode", businessTypeCode);
      map.put("businessTypeName", businessTypeName);
      map.put("sendPurchaserName", sendPurchaserName);
      map.put("sendMeikeName", sendMeikeName);
      map.put("sendInOutNameTel", sendInOutNameTel);
      map.put("companyNature", companyNature);

      return map;
  }

  public static OpCompanyBookRelation fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    OpCompanyBookRelation entity = new OpCompanyBookRelation();

    if(map.containsKey("accountBookCode")) {
      Object obj = map.get("accountBookCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountBookCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountBookName")) {
      Object obj = map.get("accountBookName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountBookName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyID")) {
      Object obj = map.get("fCompanyID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFCompanyID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyCode")) {
      Object obj = map.get("fCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyName")) {
      Object obj = map.get("fCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncSource")) {
      Object obj = map.get("syncSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f1")) {
      Object obj = map.get("f1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setF1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f2")) {
      Object obj = map.get("f2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setF2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f3")) {
      Object obj = map.get("f3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setF3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendName")) {
      Object obj = map.get("sendName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeID")) {
      Object obj = map.get("businessTypeID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTypeID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeCode")) {
      Object obj = map.get("businessTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeName")) {
      Object obj = map.get("businessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendPurchaserName")) {
      Object obj = map.get("sendPurchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendMeikeName")) {
      Object obj = map.get("sendMeikeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendMeikeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendInOutNameTel")) {
      Object obj = map.get("sendInOutNameTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendInOutNameTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNature")) {
      Object obj = map.get("companyNature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyNature((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("accountBookCode")) {
      Object obj = map.get("accountBookCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountBookCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountBookName")) {
      Object obj = map.get("accountBookName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountBookName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyID")) {
      Object obj = map.get("fCompanyID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFCompanyID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyCode")) {
      Object obj = map.get("fCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fCompanyName")) {
      Object obj = map.get("fCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncSource")) {
      Object obj = map.get("syncSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f1")) {
      Object obj = map.get("f1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setF1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f2")) {
      Object obj = map.get("f2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setF2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("f3")) {
      Object obj = map.get("f3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setF3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendName")) {
      Object obj = map.get("sendName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeID")) {
      Object obj = map.get("businessTypeID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTypeID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeCode")) {
      Object obj = map.get("businessTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTypeName")) {
      Object obj = map.get("businessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendPurchaserName")) {
      Object obj = map.get("sendPurchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendMeikeName")) {
      Object obj = map.get("sendMeikeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendMeikeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendInOutNameTel")) {
      Object obj = map.get("sendInOutNameTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendInOutNameTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNature")) {
      Object obj = map.get("companyNature");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyNature((String)obj);
        }
      } else{
      }
    }
  }
}
