package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum AuthStatusEnum {

    _1("1", "不可勾选"),
    _2("2", "未勾选"),
    _3("3", "勾选中"),
    _4("4", "已勾选"),
    _5("5", "勾选失败"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatusEnum fromCode(String code) {
        return Stream.of(AuthStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
