package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_style_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum AuthStyleEnum {

    _10("10", "平台页面勾选"),
    _11("11", "平台接口勾选"),
    _12("12", "国税底账勾选"),
    _0("0", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStyleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyleEnum fromCode(String code) {
        return Stream.of(AuthStyleEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
