package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * carryover_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum CarryoverStatusEnum {

    _0("0", "未结转"),
    _1("1", "结转中"),
    _2("2", "已结转"),
    _3("3", "结转失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CarryoverStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CarryoverStatusEnum fromCode(String code) {
        return Stream.of(CarryoverStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
