package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * creation_method
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum CreationMethod {

    SYNC("sync", "同步"),
    MANUAL("manual", "手动创建");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CreationMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CreationMethod fromCode(String code) {
        return Stream.of(CreationMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
