package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum RedFlag {

    _1("1", "待红冲 "),
    _2("2", "待部分红冲"),
    _3("3", "红冲"),
    _4("4", "部分红冲"),
    _0("0", "默认"),
    _5("5", "全额冲红");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedFlag fromCode(String code) {
        return Stream.of(RedFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
