package com.xforceplus.ultraman.app.jcyangolocal.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * print_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public enum PrintStatusEnum {

    _1("1", "已打印"),
    _0("0", "未打印");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PrintStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PrintStatusEnum fromCode(String code) {
        return Stream.of(PrintStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
