package com.xforceplus.ultraman.app.jcyangolocal.metadata.validator;

import com.xforceplus.ultraman.app.jcyangolocal.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcyangolocal.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-08
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AbandonFlagEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AbandonFlagEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AbandonFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessBillTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessBillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IdentifyStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IdentifyStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IdentifyStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColorEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColorEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColorEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockFlagEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockFlagEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(PrintStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PrintStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PrintStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VeriStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VeriStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSourceEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSourceEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSourceEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlagEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialInvoiceFlagEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFlagEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IssueFlagEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IssueFlagEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatusEnums.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatusEnums.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatusEnums.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyleEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStyleEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStyleEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(CarryoverStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CarryoverStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CarryoverStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatusEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
